/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Kernel
extends LifecycleAdapter
implements KernelAPI {
    private final KernelTransactions transactions;
    private final TransactionHooks hooks;
    private final KernelHealth health;
    private final TransactionMonitor transactionMonitor;

    public Kernel(KernelTransactions transactionFactory, TransactionHooks hooks, KernelHealth health, TransactionMonitor transactionMonitor) {
        this.transactions = transactionFactory;
        this.hooks = hooks;
        this.health = health;
        this.transactionMonitor = transactionMonitor;
    }

    @Override
    public KernelTransaction newTransaction() throws TransactionFailureException {
        this.health.assertHealthy(TransactionFailureException.class);
        KernelTransaction transaction = this.transactions.newInstance();
        this.transactionMonitor.transactionStarted();
        return transaction;
    }

    @Override
    public void registerTransactionHook(TransactionHook hook) {
        this.hooks.register(hook);
    }

    @Override
    public void unregisterTransactionHook(TransactionHook hook) {
        this.hooks.unregister(hook);
    }

    @Override
    public void stop() throws Throwable {
        this.transactions.disposeAll();
    }
}

