/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.api.cursor.RelationshipItem;
import org.neo4j.kernel.impl.api.store.StoreIteratorNodeCursor;
import org.neo4j.kernel.impl.api.store.StoreIteratorRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleNodeCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleRelationshipCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;

public class StoreStatement
implements AutoCloseable {
    private final InstanceCache<StoreSingleNodeCursor> singleNodeCursor;
    private final InstanceCache<StoreIteratorNodeCursor> iteratorNodeCursor;
    private final InstanceCache<StoreSingleRelationshipCursor> singleRelationshipCursor;
    private final InstanceCache<StoreIteratorRelationshipCursor> iteratorRelationshipCursor;
    private final NeoStores neoStores;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;

    public StoreStatement(final NeoStores neoStores, final LockService lockService) {
        this.neoStores = neoStores;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.singleNodeCursor = new InstanceCache<StoreSingleNodeCursor>(){

            @Override
            protected StoreSingleNodeCursor create() {
                return new StoreSingleNodeCursor(new NodeRecord(-1L), neoStores, StoreStatement.this, this, lockService);
            }
        };
        this.iteratorNodeCursor = new InstanceCache<StoreIteratorNodeCursor>(){

            @Override
            protected StoreIteratorNodeCursor create() {
                return new StoreIteratorNodeCursor(new NodeRecord(-1L), neoStores, StoreStatement.this, this, lockService);
            }
        };
        this.singleRelationshipCursor = new InstanceCache<StoreSingleRelationshipCursor>(){

            @Override
            protected StoreSingleRelationshipCursor create() {
                return new StoreSingleRelationshipCursor(new RelationshipRecord(-1L), neoStores, StoreStatement.this, this, lockService);
            }
        };
        this.iteratorRelationshipCursor = new InstanceCache<StoreIteratorRelationshipCursor>(){

            @Override
            protected StoreIteratorRelationshipCursor create() {
                return new StoreIteratorRelationshipCursor(new RelationshipRecord(-1L), neoStores, StoreStatement.this, this, lockService);
            }
        };
    }

    public Cursor<NodeItem> acquireSingleNodeCursor(long nodeId) {
        this.neoStores.assertOpen();
        return this.singleNodeCursor.get().init(nodeId);
    }

    public Cursor<NodeItem> acquireIteratorNodeCursor(PrimitiveLongIterator nodeIdIterator) {
        this.neoStores.assertOpen();
        return this.iteratorNodeCursor.get().init(nodeIdIterator);
    }

    public Cursor<RelationshipItem> acquireSingleRelationshipCursor(long relId) {
        this.neoStores.assertOpen();
        return this.singleRelationshipCursor.get().init(relId);
    }

    public Cursor<RelationshipItem> acquireIteratorRelationshipCursor(PrimitiveLongIterator iterator) {
        this.neoStores.assertOpen();
        return this.iteratorRelationshipCursor.get().init(iterator);
    }

    public Cursor<NodeItem> nodesGetAllCursor() {
        return this.acquireIteratorNodeCursor((PrimitiveLongIterator)new AllStoreIdIterator(this.nodeStore));
    }

    public Cursor<RelationshipItem> relationshipsGetAllCursor() {
        return this.acquireIteratorRelationshipCursor((PrimitiveLongIterator)new AllStoreIdIterator(this.relationshipStore));
    }

    @Override
    public void close() {
    }

    private class AllStoreIdIterator
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator {
        private final CommonAbstractStore store;
        private long highId;
        private long currentId;

        public AllStoreIdIterator(CommonAbstractStore store) {
            this.store = store;
            this.highId = store.getHighestPossibleIdInUse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean fetchNext() {
            while (true) {
                if (this.currentId <= this.highId) {
                    try {
                        boolean bl = this.next(this.currentId);
                        return bl;
                    }
                    finally {
                        ++this.currentId;
                    }
                }
                long newHighId = this.store.getHighestPossibleIdInUse();
                if (newHighId <= this.highId) break;
                this.highId = newHighId;
            }
            return false;
        }
    }
}

