/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class RecoveryLabelScanWriterProvider
implements Provider<LabelScanWriter>,
Closeable {
    private int callCount;
    private final LabelScanStore labelScanStore;
    private final RecoveryLabelScanWriter recoveryWriter = new RecoveryLabelScanWriter();
    private final int batchSize;

    public RecoveryLabelScanWriterProvider(LabelScanStore labelScanStore, int batchSize) {
        this.labelScanStore = labelScanStore;
        this.batchSize = batchSize;
    }

    @Override
    public LabelScanWriter instance() {
        return this.recoveryWriter;
    }

    @Override
    public void close() throws IOException {
        this.recoveryWriter.writePendingUpdates();
    }

    private class RecoveryLabelScanWriter
    implements LabelScanWriter {
        private final List<NodeLabelUpdate> updates = new ArrayList<NodeLabelUpdate>();

        private RecoveryLabelScanWriter() {
        }

        @Override
        public void write(NodeLabelUpdate update) throws IOException, IndexCapacityExceededException {
            this.updates.add(update);
        }

        @Override
        public void close() throws IOException {
            if (++RecoveryLabelScanWriterProvider.this.callCount % RecoveryLabelScanWriterProvider.this.batchSize == 0) {
                this.writePendingUpdates();
            }
        }

        private void writePendingUpdates() throws IOException {
            if (!this.updates.isEmpty()) {
                Collections.sort(this.updates, NodeLabelUpdate.SORT_BY_NODE_ID);
                try (LabelScanWriter writer = RecoveryLabelScanWriterProvider.this.labelScanStore.newWriter();){
                    for (NodeLabelUpdate update : this.updates) {
                        writer.write(update);
                    }
                }
                catch (IndexCapacityExceededException e) {
                    throw new IOException(e);
                }
                this.updates.clear();
            }
        }
    }
}

