/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Objects;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.PropertyConstraintDefinition;

abstract class NodeConstraintDefinition
extends PropertyConstraintDefinition {
    protected final Label label;

    protected NodeConstraintDefinition(InternalSchemaActions actions, Label label, String propertyKey) {
        super(actions, propertyKey);
        this.label = Objects.requireNonNull(label);
    }

    @Override
    public Label getLabel() {
        this.assertInUnterminatedTransaction();
        return this.label;
    }

    @Override
    public RelationshipType getRelationshipType() {
        this.assertInUnterminatedTransaction();
        throw new IllegalStateException("Constraint is associated with nodes");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeConstraintDefinition that = (NodeConstraintDefinition)o;
        return this.label.name().equals(that.label.name()) && this.propertyKey.equals(that.propertyKey);
    }

    @Override
    public int hashCode() {
        return 31 * this.label.name().hashCode() + this.propertyKey.hashCode();
    }
}

