/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public interface LegacyRelationshipStoreReader
extends Closeable {
    public long getMaxId();

    public int getRecordSize();

    public Iterator<RelationshipRecord> iterator(long var1) throws IOException;

    public static class ReusableRelationship {
        private long recordId;
        private boolean inUse;
        private long firstNode;
        private long secondNode;
        private int type;
        private long firstPrevRel;
        private long firstNextRel;
        private long secondNextRel;
        private long secondPrevRel;
        private long nextProp;
        private RelationshipRecord record;

        public void reset(long id, boolean inUse, long firstNode, long secondNode, int type, long firstPrevRel, long firstNextRel, long secondNextRel, long secondPrevRel, long nextProp) {
            this.record = null;
            this.recordId = id;
            this.inUse = inUse;
            this.firstNode = firstNode;
            this.secondNode = secondNode;
            this.type = type;
            this.firstPrevRel = firstPrevRel;
            this.firstNextRel = firstNextRel;
            this.secondNextRel = secondNextRel;
            this.secondPrevRel = secondPrevRel;
            this.nextProp = nextProp;
        }

        public boolean inUse() {
            return this.inUse;
        }

        public long getFirstNode() {
            return this.firstNode;
        }

        public long getFirstNextRel() {
            return this.firstNextRel;
        }

        public long getSecondNode() {
            return this.secondNode;
        }

        public long getFirstPrevRel() {
            return this.firstPrevRel;
        }

        public long getSecondPrevRel() {
            return this.secondPrevRel;
        }

        public long getSecondNextRel() {
            return this.secondNextRel;
        }

        public long id() {
            return this.recordId;
        }

        public RelationshipRecord createRecord() {
            if (this.record == null) {
                this.record = new RelationshipRecord(this.recordId, this.firstNode, this.secondNode, this.type);
                this.record.setInUse(this.inUse);
                this.record.setFirstPrevRel(this.firstPrevRel);
                this.record.setFirstNextRel(this.firstNextRel);
                this.record.setSecondPrevRel(this.secondPrevRel);
                this.record.setSecondNextRel(this.secondNextRel);
                this.record.setNextProp(this.nextProp);
            }
            return this.record;
        }
    }
}

