/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;

public class TransactionLogEntryCursor
implements IOCursor<LogEntry[]> {
    private final IOCursor<LogEntry> delegate;
    private final List<LogEntry> transaction = new ArrayList<LogEntry>();

    public TransactionLogEntryCursor(IOCursor<LogEntry> delegate) {
        this.delegate = delegate;
    }

    @Override
    public LogEntry[] get() {
        return this.transaction.toArray(new LogEntry[this.transaction.size()]);
    }

    @Override
    public boolean next() throws IOException {
        this.transaction.clear();
        while (this.delegate.next()) {
            LogEntry entry = this.delegate.get();
            this.transaction.add(entry);
            if (!this.isBreakPoint(entry)) continue;
            return true;
        }
        return false;
    }

    private boolean isBreakPoint(LogEntry entry) {
        return entry.getType() == 5;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

