/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class InputRelationshipCacher
extends InputEntityCacher<InputRelationship> {
    private String previousType;

    public InputRelationshipCacher(StoreChannel channel, StoreChannel header, int bufferSize) throws IOException {
        super(channel, header, bufferSize, 2);
    }

    @Override
    protected void writeEntity(InputRelationship relationship) throws IOException {
        super.writeEntity(relationship);
        if (relationship.hasSpecificId()) {
            this.channel.put((byte)1);
            this.channel.putLong(relationship.specificId());
        } else {
            this.channel.put((byte)0);
        }
        this.writeGroup(relationship.startNodeGroup(), 0);
        this.writeGroup(relationship.endNodeGroup(), 1);
        this.writeValue(relationship.startNode());
        this.writeValue(relationship.endNode());
        if (relationship.hasTypeId()) {
            this.channel.put((byte)2);
            this.channel.putInt(relationship.typeId());
        } else if (this.previousType != null && relationship.type().equals(this.previousType)) {
            this.channel.put((byte)0);
        } else {
            this.channel.put((byte)1);
            this.previousType = relationship.type();
            this.writeToken(this.previousType);
        }
    }
}

