/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobQueue;

public class IndexSamplingJobQueueTest {
    public static final Predicate<Object> TRUE = Predicates.alwaysTrue();
    public static final Predicate<Object> FALSE = Predicates.alwaysFalse();
    private final Object something = new Object();

    @Test
    public void returnsNullWhenEmpty() {
        Assert.assertNull((Object)new IndexSamplingJobQueue(Predicates.alwaysTrue()).poll());
    }

    @Test
    public void shouldEnqueueJobWhenEmpty() {
        IndexSamplingJobQueue jobQueue = new IndexSamplingJobQueue(TRUE);
        jobQueue.add(false, this.something);
        Object result = jobQueue.poll();
        Assert.assertEquals((Object)this.something, (Object)result);
    }

    @Test
    public void shouldEnqueueJobOnlyOnce() {
        IndexSamplingJobQueue jobQueue = new IndexSamplingJobQueue(TRUE);
        jobQueue.add(false, this.something);
        jobQueue.add(false, this.something);
        Assert.assertEquals((Object)this.something, (Object)jobQueue.poll());
        Assert.assertNull((Object)jobQueue.poll());
    }

    @Test
    public void shouldNotEnqueueJobOnlyIfForbiddenByThePredicate() {
        IndexSamplingJobQueue jobQueue = new IndexSamplingJobQueue(FALSE);
        jobQueue.add(false, this.something);
        Assert.assertNull((Object)jobQueue.poll());
    }

    @Test
    public void shouldForceEnqueueOfAnJobEvenIfThePredicateForbidsIt() {
        IndexSamplingJobQueue jobQueue = new IndexSamplingJobQueue(FALSE);
        jobQueue.add(true, this.something);
        Assert.assertEquals((Object)this.something, (Object)jobQueue.poll());
    }

    @Test
    public void shouldDequeueAll() {
        Object somethingElse = new Object();
        IndexSamplingJobQueue jobQueue = new IndexSamplingJobQueue(TRUE);
        jobQueue.add(false, this.something);
        jobQueue.add(false, somethingElse);
        Iterable objects = jobQueue.pollAll();
        Assert.assertArrayEquals((Object[])new Object[]{this.something, somethingElse}, (Object[])Iterables.toArray(Object.class, (Iterable)objects));
        Assert.assertNull((Object)jobQueue.poll());
    }
}

