/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Neo4jMockitoHelpers;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.index.LegacyIndexStore;

public class LabelTransactionStateTest {
    private final int labelId1 = 10;
    private final int labelId2 = 12;
    private final long nodeId = 20L;
    private StoreReadLayer store;
    private TransactionState txState;
    private StateHandlingStatementOperations txContext;
    private KernelStatement state;
    private StoreStatement storeStatement;

    @Before
    public void before() throws Exception {
        this.store = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)this.store.indexesGetForLabel(10)).then(Neo4jMockitoHelpers.answerAsIteratorFrom(Collections.emptyList()));
        Mockito.when((Object)this.store.indexesGetForLabel(12)).then(Neo4jMockitoHelpers.answerAsIteratorFrom(Collections.emptyList()));
        Mockito.when((Object)this.store.indexesGetAll()).then(Neo4jMockitoHelpers.answerAsIteratorFrom(Collections.emptyList()));
        this.txState = new TxState();
        this.state = StatementOperationsTestHelper.mockedState(this.txState);
        this.txContext = new StateHandlingStatementOperations(this.store, (LegacyPropertyTrackers)Mockito.mock(LegacyPropertyTrackers.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (LegacyIndexStore)Mockito.mock(LegacyIndexStore.class));
        this.storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)this.state.getStoreStatement()).thenReturn((Object)this.storeStatement);
    }

    @Test
    public void addOnlyLabelShouldBeVisibleInTx() throws Exception {
        this.commitNoLabels();
        this.txContext.nodeAddLabel(this.state, 20L, 10);
        this.assertLabels(10);
    }

    @Test
    public void addAdditionalLabelShouldBeReflectedWithinTx() throws Exception {
        this.commitLabels(10);
        this.txContext.nodeAddLabel(this.state, 20L, 12);
        this.assertLabels(10, 12);
    }

    @Test
    public void addAlreadyExistingLabelShouldBeReflectedWithinTx() throws Exception {
        this.commitLabels(10);
        this.txContext.nodeAddLabel(this.state, 20L, 10);
        this.assertLabels(10);
    }

    @Test
    public void removeCommittedLabelShouldBeReflectedWithinTx() throws Exception {
        this.commitLabels(10, 12);
        this.txContext.nodeRemoveLabel(this.state, 20L, 10);
        this.assertLabels(12);
    }

    @Test
    public void removeAddedLabelInTxShouldBeReflectedWithinTx() throws Exception {
        this.commitLabels(10);
        this.txContext.nodeAddLabel(this.state, 20L, 12);
        this.txContext.nodeRemoveLabel(this.state, 20L, 12);
        this.assertLabels(10);
    }

    @Test
    public void addRemovedLabelInTxShouldBeReflectedWithinTx() throws Exception {
        this.commitLabels(10);
        this.txContext.nodeRemoveLabel(this.state, 20L, 10);
        this.txContext.nodeAddLabel(this.state, 20L, 10);
        this.assertLabels(10);
    }

    @Test
    public void addedLabelsShouldBeReflectedWhenGettingNodesForLabel() throws Exception {
        this.commitLabels(LabelTransactionStateTest.labels(0L, 1, 2), LabelTransactionStateTest.labels(1L, 2, 3), LabelTransactionStateTest.labels(2L, 1, 3));
        this.txContext.nodeAddLabel(this.state, 2L, 2);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{0L, 1L, 2L}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)this.txContext.nodesGetForLabel(this.state, 2)));
    }

    @Test
    public void removedLabelsShouldBeReflectedWhenGettingNodesForLabel() throws Exception {
        this.commitLabels(LabelTransactionStateTest.labels(0L, 1, 2), LabelTransactionStateTest.labels(1L, 2, 3), LabelTransactionStateTest.labels(2L, 1, 3));
        this.txContext.nodeRemoveLabel(this.state, 1L, 2);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{0L}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)this.txContext.nodesGetForLabel(this.state, 2)));
    }

    @Test
    public void addingNewLabelToNodeShouldRespondTrue() throws Exception {
        this.commitNoLabels();
        boolean added = this.txContext.nodeAddLabel(this.state, 20L, 10);
        Assert.assertTrue((String)"Should have been added now", (boolean)added);
    }

    @Test
    public void addingExistingLabelToNodeShouldRespondFalse() throws Exception {
        this.commitLabels(10);
        boolean added = this.txContext.nodeAddLabel(this.state, 20L, 10);
        Assert.assertFalse((String)"Shouldn't have been added now", (boolean)added);
    }

    @Test
    public void removingExistingLabelFromNodeShouldRespondTrue() throws Exception {
        this.commitLabels(10);
        boolean removed = this.txContext.nodeRemoveLabel(this.state, 20L, 10);
        Assert.assertTrue((String)"Should have been removed now", (boolean)removed);
    }

    @Test
    public void removingNonExistentLabelFromNodeShouldRespondFalse() throws Exception {
        this.commitNoLabels();
        this.txContext.nodeAddLabel(this.state, 20L, 10);
        this.assertLabels(10);
    }

    @Test
    public void should_return_true_when_adding_new_label() throws Exception {
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1337L)).thenReturn(StubCursors.asNodeCursor(1337L));
        boolean added = this.txContext.nodeAddLabel(this.state, 1337L, 12);
        Assert.assertTrue((String)"Label should have been added", (boolean)added);
    }

    @Test
    public void should_return_false_when_adding_existing_label() throws Exception {
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1337L)).thenReturn(StubCursors.asNodeCursor(1337L, StubCursors.asPropertyCursor(new DefinedProperty[0]), StubCursors.asLabelCursor(12)));
        boolean added = this.txContext.nodeAddLabel(this.state, 1337L, 12);
        Assert.assertFalse((String)"Label should have been added", (boolean)added);
    }

    @Test
    public void should_return_true_when_removing_existing_label() throws Exception {
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1337L)).thenReturn(StubCursors.asNodeCursor(1337L, StubCursors.asPropertyCursor(new DefinedProperty[0]), StubCursors.asLabelCursor(12)));
        boolean added = this.txContext.nodeRemoveLabel(this.state, 1337L, 12);
        Assert.assertTrue((String)"Label should have been removed", (boolean)added);
    }

    @Test
    public void should_return_true_when_removing_non_existant_label() throws Exception {
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1337L)).thenReturn(StubCursors.asNodeCursor(1337L));
        boolean removed = this.txContext.nodeRemoveLabel(this.state, 1337L, 12);
        Assert.assertFalse((String)"Label should have been removed", (boolean)removed);
    }

    private static Labels labels(long nodeId, Integer ... labelIds) {
        return new Labels(nodeId, labelIds);
    }

    private void commitLabels(Labels ... labels) throws Exception {
        HashMap<Integer, ArrayList<Long>> allLabels = new HashMap<Integer, ArrayList<Long>>();
        for (Labels nodeLabels : labels) {
            Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(nodeLabels.nodeId)).thenReturn(StubCursors.asNodeCursor(nodeLabels.nodeId, StubCursors.asPropertyCursor(new DefinedProperty[0]), StubCursors.asLabelCursor(nodeLabels.labelIds)));
            Integer[] arr$ = nodeLabels.labelIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int label = arr$[i$];
                ArrayList<Long> nodes = (ArrayList<Long>)allLabels.get(label);
                if (nodes == null) {
                    nodes = new ArrayList<Long>();
                    allLabels.put(label, nodes);
                }
                nodes.add(nodeLabels.nodeId);
            }
        }
        for (Map.Entry entry : allLabels.entrySet()) {
            Mockito.when((Object)this.store.nodesGetForLabel(this.state, ((Integer)entry.getKey()).intValue())).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom((Iterable)entry.getValue()));
        }
    }

    private void commitNoLabels() throws Exception {
        this.commitLabels(new Integer[0]);
    }

    private void commitLabels(Integer ... labels) throws Exception {
        this.commitLabels(LabelTransactionStateTest.labels(20L, labels));
    }

    private void assertLabels(Integer ... labels) throws EntityNotFoundException {
        try (Cursor cursor = this.txContext.nodeCursor(this.state, 20L);){
            if (cursor.next()) {
                Assert.assertEquals((Object)IteratorUtil.asSet((Object[])labels), (Object)IteratorUtil.asSet((PrimitiveIntIterator)((NodeItem)cursor.get()).getLabels()));
            }
        }
        Integer[] arr$ = labels;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int label = arr$[i$];
            try (Cursor cursor = this.txContext.nodeCursor(this.state, 20L);){
                if (!cursor.next()) continue;
                Assert.assertTrue((String)"Expected labels not found on node", (boolean)((NodeItem)cursor.get()).hasLabel(label));
                continue;
            }
        }
    }

    private static class Labels {
        private final long nodeId;
        private final Integer[] labelIds;

        Labels(long nodeId, Integer ... labelIds) {
            this.nodeId = nodeId;
            this.labelIds = labelIds;
        }
    }
}

