/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.api.state.PropertyChanges;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.kernel.impl.util.diffsets.ReadableDiffSets;

public class PropertyChangesTest {
    @Test
    public void shouldListChanges() throws Exception {
        PropertyChanges changes = new PropertyChanges();
        changes.changeProperty(1L, 2, (Object)"from", (Object)"to");
        changes.addProperty(1L, 3, (Object)"from");
        changes.removeProperty(2L, 2, (Object)"to");
        MatcherAssert.assertThat((Object)changes.changesForProperty(2, (Object)"to"), this.isDiffSets(IteratorUtil.asSet((Object[])new Long[]{1L}), IteratorUtil.asSet((Object[])new Long[]{2L})));
        MatcherAssert.assertThat((Object)changes.changesForProperty(3, (Object)"from"), this.isDiffSets(IteratorUtil.asSet((Object[])new Long[]{1L}), null));
        MatcherAssert.assertThat((Object)changes.changesForProperty(2, (Object)"from"), this.isDiffSets(null, IteratorUtil.asSet((Object[])new Long[]{1L})));
    }

    private Matcher<? super ReadableDiffSets<Long>> isDiffSets(Set<Long> added, Set<Long> removed) {
        return CoreMatchers.equalTo((Object)new DiffSets(added, removed));
    }
}

