/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.performance;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.RagManager;

public class PerformanceTestLegacyLocks {
    public static void main(String ... args) throws InterruptedException {
        boolean numThreads = true;
        int numLocks = 8;
        int iterations = 1000000;
        int numResources = 1024;
        Object[] resources = PerformanceTestLegacyLocks.newResources(1024);
        final LockManagerImpl lockManager = new LockManagerImpl(new RagManager());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        long start = System.currentTimeMillis();
        int i = 1;
        while (i-- > 0) {
            executor.execute(new Runnable(){
                private final Transaction tx = new NoOpTransaction();
                final Object[] localResources = PerformanceTestLegacyLocks.access$100(1024);

                @Override
                public void run() {
                    Object[] acquired = new Object[8];
                    ThreadLocalRandom rand = ThreadLocalRandom.current();
                    int i = 1000000;
                    while (i-- > 0) {
                        int currentLock;
                        try {
                            for (currentLock = 0; currentLock < 8; ++currentLock) {
                                Object resource = this.localResources[rand.nextInt(1024)];
                                lockManager.getWriteLock(resource, (Object)this.tx);
                                acquired[currentLock] = resource;
                            }
                        }
                        catch (DeadlockDetectedException deadlockDetectedException) {
                            // empty catch block
                        }
                        while (currentLock-- > 0) {
                            lockManager.releaseWriteLock(acquired[currentLock], (Object)this.tx);
                        }
                    }
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.HOURS);
        long delta = System.currentTimeMillis() - start;
        double locksPerSecond = 8000000.0 / ((double)delta / 1000.0);
        System.out.println("Locks per second: " + locksPerSecond);
        System.out.println("Deadlocks: " + lockManager.getDetectedDeadlockCount());
    }

    private static Object[] newResources(int numResources) {
        Object[] resources = new Object[numResources];
        int i = numResources;
        while (i-- > 0) {
            resources[i] = new Object();
        }
        return resources;
    }

    static /* synthetic */ Object[] access$100(int x0) {
        return PerformanceTestLegacyLocks.newResources(x0);
    }

    private static class NoOpTransaction
    implements Transaction {
        private NoOpTransaction() {
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
        }

        public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
            return false;
        }

        public boolean enlistResource(XAResource xaRes) throws IllegalStateException, RollbackException, SystemException {
            return false;
        }

        public int getStatus() throws SystemException {
            return 0;
        }

        public void registerSynchronization(Synchronization synch) throws IllegalStateException, RollbackException, SystemException {
        }

        public void rollback() throws IllegalStateException, SystemException {
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
        }
    }
}

