/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

@RunWith(value=Parameterized.class)
public class StoreMigratorTest {
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    public final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    private final SchemaIndexProvider schemaIndexProvider = new InMemoryIndexProvider();
    @Parameterized.Parameter(value=0)
    public String version;
    @Parameterized.Parameter(value=1)
    public LogPosition expectedLogPosition;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> versions() {
        return Arrays.asList({"v0.A.0", new LogPosition(0L, 16L)}, {"v0.A.1", new LogPosition(0L, 16L)}, {"v0.A.3", new LogPosition(0L, 16L)}, {"v0.A.5", new LogPosition(2L, 16L)});
    }

    @Test
    public void shouldBeAbleToResumeMigrationOnMoving() throws Exception {
        File storeDirectory = this.directory.graphDbDir();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, storeDirectory, prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(pageCache), new LegacyStoreVersionCheck(this.fs));
        String versionToMigrateFrom = upgradableDatabase.checkUpgradeable(storeDirectory);
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator((MigrationProgressMonitor)progressMonitor, this.fs, pageCache, new Config(), (LogService)logService);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdirs(migrationDir);
        migrator.migrate(storeDirectory, migrationDir, this.schemaIndexProvider, versionToMigrateFrom);
        progressMonitor = new SilentMigrationProgressMonitor();
        migrator = new StoreMigrator((MigrationProgressMonitor)progressMonitor, this.fs, pageCache, new Config(), (LogService)logService);
        migrator.moveMigratedFiles(migrationDir, storeDirectory, versionToMigrateFrom);
        StoreFactory storeFactory = new StoreFactory(this.fs, storeDirectory, pageCache, logService.getInternalLogProvider());
        storeFactory.openAllNeoStores().close();
    }

    @Test
    public void shouldBeAbleToResumeMigrationOnRebuildingCounts() throws Exception {
        File storeDirectory = this.directory.graphDbDir();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, storeDirectory, prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(pageCache), new LegacyStoreVersionCheck(this.fs));
        String versionToMigrateFrom = upgradableDatabase.checkUpgradeable(storeDirectory);
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator((MigrationProgressMonitor)progressMonitor, this.fs, pageCache, new Config(), (LogService)logService);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdirs(migrationDir);
        migrator.migrate(storeDirectory, migrationDir, this.schemaIndexProvider, versionToMigrateFrom);
        migrator.moveMigratedFiles(migrationDir, storeDirectory, versionToMigrateFrom);
        progressMonitor = new SilentMigrationProgressMonitor();
        migrator = new StoreMigrator((MigrationProgressMonitor)progressMonitor, this.fs, pageCache, new Config(), (LogService)logService);
        migrator.rebuildCounts(storeDirectory, versionToMigrateFrom);
        StoreFactory storeFactory = new StoreFactory(this.fs, storeDirectory, pageCache, logService.getInternalLogProvider());
        storeFactory.openAllNeoStores().close();
    }

    @Test
    public void shouldComputeTheLastTxLogPositionCorrectly() throws Throwable {
        File storeDirectory = this.directory.graphDbDir();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, storeDirectory, prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(pageCache), new LegacyStoreVersionCheck(this.fs));
        String versionToMigrateFrom = upgradableDatabase.checkUpgradeable(storeDirectory);
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator((MigrationProgressMonitor)progressMonitor, this.fs, pageCache, new Config(), (LogService)logService);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdirs(migrationDir);
        migrator.migrate(storeDirectory, migrationDir, this.schemaIndexProvider, versionToMigrateFrom);
        Assert.assertEquals((Object)this.expectedLogPosition, (Object)StoreMigrator.readLastTxLogPosition((FileSystemAbstraction)this.fs, (File)migrationDir));
    }
}

