/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.ArrayQueueOutOfOrderSequence;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;

public class DeadSimpleTransactionIdStore
implements TransactionIdStore {
    private final AtomicLong committingTransactionId = new AtomicLong();
    private final OutOfOrderSequence closedTransactionId = new ArrayQueueOutOfOrderSequence(-1L, 100, new long[1]);
    private final AtomicReference<TransactionId> committedTransactionId = new AtomicReference<TransactionId>(new TransactionId(1L, 0L));
    private final long previouslyCommittedTxId;
    private final long initialTransactionChecksum;

    public DeadSimpleTransactionIdStore() {
        this(1L, 0L, 0L, 16L);
    }

    public DeadSimpleTransactionIdStore(long previouslyCommittedTxId, long checksum, long previouslyCommittedTxLogVersion, long previouslyCommittedTxLogByteOffset) {
        assert (previouslyCommittedTxId >= 1L) : "cannot start from a tx id less than BASE_TX_ID";
        this.setLastCommittedAndClosedTransactionId(previouslyCommittedTxId, checksum, previouslyCommittedTxLogVersion, previouslyCommittedTxLogByteOffset);
        this.previouslyCommittedTxId = previouslyCommittedTxId;
        this.initialTransactionChecksum = checksum;
    }

    public long nextCommittingTransactionId() {
        return this.committingTransactionId.incrementAndGet();
    }

    public synchronized void transactionCommitted(long transactionId, long checksum) {
        TransactionId current = this.committedTransactionId.get();
        if (current == null || transactionId > current.transactionId()) {
            this.committedTransactionId.set(new TransactionId(transactionId, checksum));
        }
    }

    public long getLastCommittedTransactionId() {
        return this.committedTransactionId.get().transactionId();
    }

    public TransactionId getLastCommittedTransaction() {
        return this.committedTransactionId.get();
    }

    public TransactionId getUpgradeTransaction() {
        return new TransactionId(this.previouslyCommittedTxId, this.initialTransactionChecksum);
    }

    public long getLastClosedTransactionId() {
        return this.closedTransactionId.getHighestGapFreeNumber();
    }

    public long[] getLastClosedTransaction() {
        return this.closedTransactionId.get();
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, long checksum, long logVersion, long byteOffset) {
        this.committingTransactionId.set(transactionId);
        this.committedTransactionId.set(new TransactionId(transactionId, checksum));
        this.closedTransactionId.set(transactionId, new long[]{checksum, logVersion, byteOffset});
    }

    public void transactionClosed(long transactionId, long logVersion, long byteOffset) {
        this.closedTransactionId.offer(transactionId, new long[]{logVersion, byteOffset});
    }

    public boolean closedTransactionIdIsOnParWithOpenedTransactionId() {
        return this.closedTransactionId.getHighestGapFreeNumber() == this.committedTransactionId.get().transactionId();
    }

    public void flush() {
    }
}

