/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2_4;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;

public class PhysicalLogNeoCommandReaderV2_2_4Test {
    @Test
    public void shouldReadNoKeyIdAsMinusOne() throws Exception {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        CommandWriter writer = new CommandWriter((WritableLogChannel)channel);
        IndexDefineCommand definitions = new IndexDefineCommand();
        int indexNameId = 10;
        definitions.init(MapUtil.genericMap((Object[])new Object[]{"myindex", indexNameId}), MapUtil.genericMap((Object[])new Object[0]));
        writer.visitIndexDefineCommand(definitions);
        IndexCommand.RemoveCommand removeCommand = new IndexCommand.RemoveCommand();
        removeCommand.init(indexNameId, IndexEntityType.Node.id(), 1234L, -1, null);
        writer.visitIndexRemoveCommand(removeCommand);
        PhysicalLogCommandReaderV2_2_4 reader = new PhysicalLogCommandReaderV2_2_4();
        Assert.assertTrue((boolean)(reader.read((ReadableLogChannel)channel) instanceof IndexDefineCommand));
        IndexCommand.RemoveCommand readRemoveCommand = (IndexCommand.RemoveCommand)reader.read((ReadableLogChannel)channel);
        Assert.assertEquals((long)removeCommand.getIndexNameId(), (long)readRemoveCommand.getIndexNameId());
        Assert.assertEquals((long)removeCommand.getEntityType(), (long)readRemoveCommand.getEntityType());
        Assert.assertEquals((long)removeCommand.getEntityId(), (long)readRemoveCommand.getEntityId());
        Assert.assertEquals((long)removeCommand.getKeyId(), (long)readRemoveCommand.getKeyId());
        Assert.assertNull((Object)removeCommand.getValue());
    }
}

