/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class DepthPitfallGraphTest
extends TraversalTestBase {
    private static final String[] THE_WORLD_AS_WE_KNOW_IT = new String[]{"1 TO 2", "1 TO 3", "1 TO 4", "5 TO 3", "1 TO 5", "4 TO 5", "2 TO 6", "5 TO 6"};
    private static final String[] NODE_UNIQUE_PATHS = new String[]{"1", "1,2", "1,2,6", "1,2,6,5", "1,2,6,5,3", "1,2,6,5,4", "1,3", "1,3,5", "1,3,5,4", "1,3,5,6", "1,3,5,6,2", "1,4", "1,4,5", "1,4,5,3", "1,4,5,6", "1,4,5,6,2", "1,5", "1,5,3", "1,5,4", "1,5,6", "1,5,6,2"};
    private static final String[] RELATIONSHIP_UNIQUE_EXTRA_PATHS = new String[]{"1,2,6,5,1", "1,2,6,5,1,3", "1,2,6,5,1,3,5", "1,2,6,5,1,3,5,4", "1,2,6,5,1,3,5,4,1", "1,2,6,5,1,4", "1,2,6,5,1,4,5", "1,2,6,5,1,4,5,3", "1,2,6,5,1,4,5,3,1", "1,2,6,5,3,1", "1,2,6,5,3,1,4", "1,2,6,5,3,1,4,5", "1,2,6,5,3,1,4,5,1", "1,2,6,5,3,1,5", "1,2,6,5,3,1,5,4", "1,2,6,5,3,1,5,4,1", "1,2,6,5,4,1", "1,2,6,5,4,1,3", "1,2,6,5,4,1,3,5", "1,2,6,5,4,1,3,5,1", "1,2,6,5,4,1,5", "1,2,6,5,4,1,5,3", "1,2,6,5,4,1,5,3,1", "1,3,5,1", "1,3,5,1,2", "1,3,5,1,2,6", "1,3,5,1,2,6,5", "1,3,5,1,2,6,5,4", "1,3,5,1,2,6,5,4,1", "1,3,5,1,4", "1,3,5,1,4,5", "1,3,5,1,4,5,6", "1,3,5,1,4,5,6,2", "1,3,5,1,4,5,6,2,1", "1,3,5,4,1", "1,3,5,4,1,2", "1,3,5,4,1,2,6", "1,3,5,4,1,2,6,5", "1,3,5,4,1,2,6,5,1", "1,3,5,4,1,5", "1,3,5,4,1,5,6", "1,3,5,4,1,5,6,2", "1,3,5,4,1,5,6,2,1", "1,3,5,6,2,1", "1,3,5,6,2,1,4", "1,3,5,6,2,1,4,5", "1,3,5,6,2,1,4,5,1", "1,3,5,6,2,1,5", "1,3,5,6,2,1,5,4", "1,3,5,6,2,1,5,4,1", "1,4,5,1", "1,4,5,1,2", "1,4,5,1,2,6", "1,4,5,1,2,6,5", "1,4,5,1,2,6,5,3", "1,4,5,1,2,6,5,3,1", "1,4,5,1,3", "1,4,5,1,3,5", "1,4,5,1,3,5,6", "1,4,5,1,3,5,6,2", "1,4,5,1,3,5,6,2,1", "1,4,5,3,1", "1,4,5,3,1,2", "1,4,5,3,1,2,6", "1,4,5,3,1,2,6,5", "1,4,5,3,1,2,6,5,1", "1,4,5,3,1,5", "1,4,5,3,1,5,6", "1,4,5,3,1,5,6,2", "1,4,5,3,1,5,6,2,1", "1,4,5,6,2,1", "1,4,5,6,2,1,3", "1,4,5,6,2,1,3,5", "1,4,5,6,2,1,3,5,1", "1,4,5,6,2,1,5", "1,4,5,6,2,1,5,3", "1,4,5,6,2,1,5,3,1", "1,5,3,1", "1,5,3,1,2", "1,5,3,1,2,6", "1,5,3,1,2,6,5", "1,5,3,1,2,6,5,4", "1,5,3,1,2,6,5,4,1", "1,5,3,1,4", "1,5,3,1,4,5", "1,5,3,1,4,5,6", "1,5,3,1,4,5,6,2", "1,5,3,1,4,5,6,2,1", "1,5,4,1", "1,5,4,1,2", "1,5,4,1,2,6", "1,5,4,1,2,6,5", "1,5,4,1,2,6,5,3", "1,5,4,1,2,6,5,3,1", "1,5,4,1,3", "1,5,4,1,3,5", "1,5,4,1,3,5,6", "1,5,4,1,3,5,6,2", "1,5,4,1,3,5,6,2,1", "1,5,6,2,1", "1,5,6,2,1,3", "1,5,6,2,1,3,5", "1,5,6,2,1,3,5,4", "1,5,6,2,1,3,5,4,1", "1,5,6,2,1,4", "1,5,6,2,1,4,5", "1,5,6,2,1,4,5,3", "1,5,6,2,1,4,5,3,1"};

    @Before
    public void setup() {
        this.createGraph(THE_WORLD_AS_WE_KNOW_IT);
    }

    @Test
    public void testSmallestPossibleInit() throws Exception {
        Traverser traversal = Traversal.traversal().traverse(this.node("1"));
        int count = 0;
        try (Transaction transaction = this.beginTx();){
            for (Path position : traversal) {
                ++count;
                Assert.assertNotNull((Object)position);
                Assert.assertNotNull((Object)position.endNode());
                if (position.length() > 0) {
                    Assert.assertNotNull((Object)position.lastRelationship());
                }
                Assert.assertNotNull((Object)position.length());
            }
            Assert.assertFalse((String)"empty traversal", (count == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAllNodesAreReturnedOnceDepthFirst() throws Exception {
        this.testAllNodesAreReturnedOnce(Traversal.traversal().depthFirst());
    }

    @Test
    public void testAllNodesAreReturnedOnceBreadthFirst() throws Exception {
        this.testAllNodesAreReturnedOnce(Traversal.traversal().breadthFirst());
    }

    private void testAllNodesAreReturnedOnce(TraversalDescription traversal) {
        Traverser traverser = traversal.uniqueness((UniquenessFactory)Uniqueness.NODE_GLOBAL).traverse(this.node("1"));
        this.expectNodes(traverser, "1", "2", "3", "4", "5", "6");
    }

    @Test
    public void testNodesAreReturnedOnceWhenSufficientRecentlyUniqueDepthFirst() throws Exception {
        this.testNodesAreReturnedOnceWhenSufficientRecentlyUnique(Traversal.traversal().depthFirst());
    }

    @Test
    public void testNodesAreReturnedOnceWhenSufficientRecentlyUniqueBreadthFirst() throws Exception {
        this.testNodesAreReturnedOnceWhenSufficientRecentlyUnique(Traversal.traversal().breadthFirst());
    }

    private void testNodesAreReturnedOnceWhenSufficientRecentlyUnique(TraversalDescription description) {
        Traverser traverser = description.uniqueness((UniquenessFactory)Uniqueness.NODE_RECENT, (Object)6).traverse(this.node("1"));
        this.expectNodes(traverser, "1", "2", "3", "4", "5", "6");
    }

    @Test
    public void testAllRelationshipsAreReturnedOnceDepthFirst() throws Exception {
        this.testAllRelationshipsAreReturnedOnce(Traversal.traversal().depthFirst());
    }

    @Test
    public void testAllRelationshipsAreReturnedOnceBreadthFirst() throws Exception {
        this.testAllRelationshipsAreReturnedOnce(Traversal.traversal().breadthFirst());
    }

    private void testAllRelationshipsAreReturnedOnce(TraversalDescription description) throws Exception {
        Traverser traverser = Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_GLOBAL).traverse(this.node("1"));
        this.expectRelationships(traverser, THE_WORLD_AS_WE_KNOW_IT);
    }

    @Test
    public void testRelationshipsAreReturnedOnceWhenSufficientRecentlyUniqueDepthFirst() throws Exception {
        this.testRelationshipsAreReturnedOnceWhenSufficientRecentlyUnique(Traversal.traversal().depthFirst());
    }

    @Test
    public void testRelationshipsAreReturnedOnceWhenSufficientRecentlyUniqueBreadthFirst() throws Exception {
        this.testRelationshipsAreReturnedOnceWhenSufficientRecentlyUnique(Traversal.traversal().breadthFirst());
    }

    private void testRelationshipsAreReturnedOnceWhenSufficientRecentlyUnique(TraversalDescription description) throws Exception {
        Traverser traverser = description.uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_RECENT, (Object)THE_WORLD_AS_WE_KNOW_IT.length).traverse(this.node("1"));
        this.expectRelationships(traverser, THE_WORLD_AS_WE_KNOW_IT);
    }

    @Test
    public void testAllUniqueNodePathsAreReturnedDepthFirst() throws Exception {
        this.testAllUniqueNodePathsAreReturned(Traversal.traversal().depthFirst());
    }

    @Test
    public void testAllUniqueNodePathsAreReturnedBreadthFirst() throws Exception {
        this.testAllUniqueNodePathsAreReturned(Traversal.traversal().breadthFirst());
    }

    private void testAllUniqueNodePathsAreReturned(TraversalDescription description) throws Exception {
        Traverser traverser = description.uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).traverse(this.node("1"));
        this.expectPaths(traverser, NODE_UNIQUE_PATHS);
    }

    @Test
    public void testAllUniqueRelationshipPathsAreReturnedDepthFirst() throws Exception {
        this.testAllUniqueRelationshipPathsAreReturned(Traversal.traversal().depthFirst());
    }

    @Test
    public void testAllUniqueRelationshipPathsAreReturnedBreadthFirst() throws Exception {
        this.testAllUniqueRelationshipPathsAreReturned(Traversal.traversal().breadthFirst());
    }

    private void testAllUniqueRelationshipPathsAreReturned(TraversalDescription description) throws Exception {
        HashSet<String> expected = new HashSet<String>(Arrays.asList(NODE_UNIQUE_PATHS));
        expected.addAll(Arrays.asList(RELATIONSHIP_UNIQUE_EXTRA_PATHS));
        Traverser traverser = description.uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_PATH).traverse(this.node("1"));
        this.expectPaths(traverser, expected);
    }

    @Test
    public void canPruneTraversalAtSpecificDepthDepthFirst() {
        this.canPruneTraversalAtSpecificDepth(Traversal.traversal().depthFirst());
    }

    @Test
    public void canPruneTraversalAtSpecificDepthBreadthFirst() {
        this.canPruneTraversalAtSpecificDepth(Traversal.traversal().breadthFirst());
    }

    private void canPruneTraversalAtSpecificDepth(TraversalDescription description) {
        Traverser traverser = description.uniqueness((UniquenessFactory)Uniqueness.NONE).evaluator(Evaluators.toDepth((int)1)).traverse(this.node("1"));
        this.expectNodes(traverser, "1", "2", "3", "4", "5");
    }

    @Test
    public void canPreFilterNodesDepthFirst() {
        this.canPreFilterNodes(Traversal.traversal().depthFirst());
    }

    @Test
    public void canPreFilterNodesBreadthFirst() {
        this.canPreFilterNodes(Traversal.traversal().breadthFirst());
    }

    private void canPreFilterNodes(TraversalDescription description) {
        Traverser traverser = description.uniqueness((UniquenessFactory)Uniqueness.NONE).evaluator(Evaluators.atDepth((int)2)).traverse(this.node("1"));
        this.expectPaths(traverser, "1,2,6", "1,3,5", "1,4,5", "1,5,3", "1,5,4", "1,5,6");
    }
}

