/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureCollector;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureLookup;

public class DbStructureCollectorTest {
    @Test
    public void collectsDbStructure() {
        DbStructureCollector collector = new DbStructureCollector();
        collector.visitLabel(1, "Person");
        collector.visitLabel(2, "City");
        collector.visitPropertyKey(1, "name");
        collector.visitPropertyKey(2, "income");
        collector.visitRelationshipType(1, "LIVES_IN");
        collector.visitRelationshipType(2, "FRIEND");
        collector.visitUniqueIndex(new IndexDescriptor(1, 1), ":Person(name)", 1.0, 1L);
        collector.visitUniqueConstraint(new UniquenessConstraint(2, 1), ":Person(name)");
        collector.visitIndex(new IndexDescriptor(2, 2), ":City(income)", 0.2, 1L);
        collector.visitAllNodesCount(50L);
        collector.visitNodeCount(1, "Person", 20L);
        collector.visitNodeCount(2, "City", 30L);
        collector.visitRelCount(1, 2, -1, "(:Person)-[:FRIEND]->()", 500L);
        DbStructureLookup lookup = collector.lookup();
        Assert.assertEquals(Arrays.asList(Pair.of((Object)1, (Object)"Person"), Pair.of((Object)2, (Object)"City")), (Object)Iterables.toList((Iterator)lookup.labels()));
        Assert.assertEquals(Arrays.asList(Pair.of((Object)1, (Object)"name"), Pair.of((Object)2, (Object)"income")), (Object)Iterables.toList((Iterator)lookup.properties()));
        Assert.assertEquals(Arrays.asList(Pair.of((Object)1, (Object)"LIVES_IN"), Pair.of((Object)2, (Object)"FRIEND")), (Object)Iterables.toList((Iterator)lookup.relationshipTypes()));
        Assert.assertEquals(Arrays.asList(Pair.of((Object)"City", (Object)"name")), (Object)Iterables.toList((Iterator)lookup.knownUniqueConstraints()));
        Assert.assertEquals(Arrays.asList(Pair.of((Object)"Person", (Object)"name")), (Object)Iterables.toList((Iterator)lookup.knownUniqueIndices()));
        Assert.assertEquals(Arrays.asList(Pair.of((Object)"City", (Object)"income")), (Object)Iterables.toList((Iterator)lookup.knownIndices()));
        Assert.assertEquals((long)50L, (long)lookup.nodesWithLabelCardinality(-1));
        Assert.assertEquals((long)20L, (long)lookup.nodesWithLabelCardinality(1));
        Assert.assertEquals((long)30L, (long)lookup.nodesWithLabelCardinality(2));
        Assert.assertEquals((long)500L, (long)lookup.cardinalityByLabelsAndRelationshipType(1, 2, -1));
        Assert.assertEquals((double)1.0, (double)lookup.indexSelectivity(1, 1), (double)0.01);
        Assert.assertEquals((double)0.2, (double)lookup.indexSelectivity(2, 2), (double)0.01);
    }
}

