/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.neo4j.function.Consumer;
import org.neo4j.function.Function;
import org.neo4j.function.Functions;
import org.neo4j.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseBuilderTestTools;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.security.URLAccessValidationError;
import org.neo4j.test.AlgebraicFunction;
import org.neo4j.test.ExternalResource;

public abstract class DatabaseRule
extends ExternalResource
implements GraphDatabaseAPI {
    GraphDatabaseBuilder databaseBuilder;
    GraphDatabaseAPI database;
    private String storeDir;
    private Supplier<Statement> statementSupplier;
    private boolean startEagerly = true;

    public DatabaseRule startLazily() {
        this.startEagerly = false;
        return this;
    }

    public <T> T when(Function<GraphDatabaseService, T> function) {
        return (T)function.apply((Object)this.getGraphDatabaseService());
    }

    public void executeAndCommit(Consumer<? super GraphDatabaseService> consumer) {
        this.transaction(Functions.fromConsumer(consumer), true);
    }

    public <T> T executeAndCommit(Function<? super GraphDatabaseService, T> function) {
        return this.transaction(function, true);
    }

    public <T> T executeAndRollback(Function<? super GraphDatabaseService, T> function) {
        return this.transaction(function, false);
    }

    public <FROM, TO> AlgebraicFunction<FROM, TO> tx(final Function<FROM, TO> function) {
        return new AlgebraicFunction<FROM, TO>(){

            public TO apply(final FROM from) {
                return DatabaseRule.this.executeAndCommit(new Function<GraphDatabaseService, TO>(){

                    public TO apply(GraphDatabaseService graphDb) {
                        return function.apply(from);
                    }
                });
            }

            @Override
            public String toString() {
                return "tx( " + function + " )";
            }
        };
    }

    private <T> T transaction(Function<? super GraphDatabaseService, T> function, boolean commit) {
        GraphDatabaseService db = this.getGraphDatabaseService();
        try (Transaction tx = db.beginTx();){
            Object result = function.apply((Object)db);
            if (commit) {
                tx.success();
            }
            Object object = result;
            return (T)object;
        }
    }

    public Result execute(String query) throws QueryExecutionException {
        return this.getGraphDatabaseAPI().execute(query);
    }

    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        return this.getGraphDatabaseAPI().execute(query, parameters);
    }

    public Transaction beginTx() {
        return this.getGraphDatabaseAPI().beginTx();
    }

    public Node createNode(Label ... labels) {
        return this.getGraphDatabaseAPI().createNode(labels);
    }

    public Node getNodeById(long id) {
        return this.getGraphDatabaseService().getNodeById(id);
    }

    public IndexManager index() {
        return this.getGraphDatabaseService().index();
    }

    public Schema schema() {
        return this.getGraphDatabaseAPI().schema();
    }

    @Override
    protected void before() throws Throwable {
        this.create();
        if (this.startEagerly) {
            this.ensureStarted();
        }
    }

    @Override
    protected void after(boolean success) {
        this.shutdown(success);
    }

    private void create() throws IOException {
        this.createResources();
        try {
            GraphDatabaseFactory factory = this.newFactory();
            this.configure(factory);
            this.databaseBuilder = this.newBuilder(factory);
            this.configure(this.databaseBuilder);
        }
        catch (RuntimeException e) {
            this.deleteResources();
            throw e;
        }
    }

    protected void deleteResources() {
    }

    protected void createResources() throws IOException {
    }

    protected abstract GraphDatabaseFactory newFactory();

    protected abstract GraphDatabaseBuilder newBuilder(GraphDatabaseFactory var1);

    protected void configure(GraphDatabaseFactory databaseFactory) {
    }

    protected void configure(GraphDatabaseBuilder builder) {
    }

    public GraphDatabaseBuilder setConfig(Setting<?> setting, String value) {
        return this.databaseBuilder.setConfig(setting, value);
    }

    public Config getConfigCopy() {
        return GraphDatabaseBuilderTestTools.createConfigCopy(this.databaseBuilder);
    }

    public void resetConfig() {
        GraphDatabaseBuilderTestTools.clearConfig(this.databaseBuilder);
    }

    @Deprecated
    public GraphDatabaseService getGraphDatabaseService() {
        return this.getGraphDatabaseAPI();
    }

    public GraphDatabaseAPI getGraphDatabaseAPI() {
        this.ensureStarted();
        return this.database;
    }

    public synchronized void ensureStarted() {
        if (this.database == null) {
            this.database = (GraphDatabaseAPI)this.databaseBuilder.newGraphDatabase();
            this.storeDir = this.database.getStoreDir();
            this.statementSupplier = (Supplier)this.resolveDependency(ThreadToStatementContextBridge.class);
        }
    }

    public GraphDatabaseAPI restartDatabase() throws IOException {
        return this.restartDatabase(RestartAction.EMPTY);
    }

    public GraphDatabaseAPI restartDatabase(RestartAction action) throws IOException {
        FileSystemAbstraction fs = this.resolveDependency(FileSystemAbstraction.class);
        this.database.shutdown();
        action.run(fs, new File(this.storeDir));
        this.database = null;
        return this.getGraphDatabaseAPI();
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean deleteResources) {
        this.statementSupplier = null;
        try {
            if (this.database != null) {
                this.database.shutdown();
            }
        }
        finally {
            if (deleteResources) {
                this.deleteResources();
            }
            this.database = null;
        }
    }

    public void stopAndKeepFiles() {
        if (this.database != null) {
            this.database.shutdown();
            this.database = null;
            this.statementSupplier = null;
        }
    }

    public <T> T resolveDependency(Class<T> type) {
        return (T)this.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(type);
    }

    public Statement statement() {
        this.ensureStarted();
        return (Statement)this.statementSupplier.get();
    }

    public DependencyResolver getDependencyResolver() {
        return this.database.getDependencyResolver();
    }

    public StoreId storeId() {
        return this.database.storeId();
    }

    public String getStoreDir() {
        return this.database.getStoreDir();
    }

    public String getStoreDirAbsolutePath() {
        return new File(this.getStoreDir()).getAbsolutePath();
    }

    public File getStoreDirFile() {
        return new File(this.getStoreDir());
    }

    public URL validateURLAccess(URL url) throws URLAccessValidationError {
        return this.database.validateURLAccess(url);
    }

    public Node createNode() {
        return this.database.createNode();
    }

    public Relationship getRelationshipById(long id) {
        return this.database.getRelationshipById(id);
    }

    public Iterable<Node> getAllNodes() {
        return this.database.getAllNodes();
    }

    public ResourceIterator<Node> findNodes(Label label, String key, Object value) {
        return this.database.findNodes(label, key, value);
    }

    public Node findNode(Label label, String key, Object value) {
        return this.database.findNode(label, key, value);
    }

    public ResourceIterator<Node> findNodes(Label label) {
        return this.database.findNodes(label);
    }

    public ResourceIterable<Node> findNodesByLabelAndProperty(Label label, String key, Object value) {
        return this.database.findNodesByLabelAndProperty(label, key, value);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.database.getRelationshipTypes();
    }

    public boolean isAvailable(long timeout) {
        return this.database.isAvailable(timeout);
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.database.registerTransactionEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.database.unregisterTransactionEventHandler(handler);
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return this.database.registerKernelEventHandler(handler);
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.database.unregisterKernelEventHandler(handler);
    }

    public TraversalDescription traversalDescription() {
        return this.database.traversalDescription();
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        return this.database.bidirectionalTraversalDescription();
    }

    public static interface RestartAction {
        public static final RestartAction EMPTY = new RestartAction(){

            @Override
            public void run(FileSystemAbstraction fs, File storeDirectory) {
            }
        };

        public void run(FileSystemAbstraction var1, File var2) throws IOException;
    }
}

