/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.util.Iterator;
import java.util.List;
import org.neo4j.helpers.Exceptions;

public abstract class MultipleExceptionsStrategy {
    private static final MultipleExceptionsStrategy strategy;

    public static void assertEmpty(List<Throwable> failures) throws Throwable {
        if (failures.isEmpty()) {
            return;
        }
        if (failures.size() == 1) {
            throw failures.get(0);
        }
        throw strategy.aggregate(failures);
    }

    public static void assertEmptyExceptions(List<? extends Exception> exceptions) throws Exception {
        try {
            MultipleExceptionsStrategy.assertEmpty(MultipleExceptionsStrategy.unsafeCast(exceptions));
        }
        catch (Throwable e) {
            throw (Exception)Exceptions.launderedException(Exception.class, (Throwable)e);
        }
    }

    abstract Throwable aggregate(List<Throwable> var1);

    MultipleExceptionsStrategy() {
    }

    private static List<Throwable> unsafeCast(List<?> exceptions) {
        return exceptions;
    }

    static {
        MultipleExceptionsStrategy choice = new ChainedMultipleExceptionsStrategy();
        String pkg = MultipleExceptionsStrategy.class.getPackage().getName();
        ClassLoader loader = MultipleExceptionsStrategy.class.getClassLoader();
        for (String name : new String[]{"JUnitMultipleExceptions"}) {
            try {
                choice = (MultipleExceptionsStrategy)loader.loadClass(pkg + "." + name).newInstance();
                break;
            }
            catch (Throwable e) {
            }
        }
        strategy = choice;
    }

    private static class ChainedMultipleExceptionsStrategy
    extends MultipleExceptionsStrategy {
        private ChainedMultipleExceptionsStrategy() {
        }

        @Override
        Throwable aggregate(List<Throwable> failures) {
            Throwable result = null;
            Iterator<Throwable> i$ = failures.iterator();
            while (i$.hasNext()) {
                Throwable throwable;
                Throwable last = throwable = i$.next();
                for (Throwable cause = last.getCause(); cause != null; cause = cause.getCause()) {
                    last = cause;
                }
                last.initCause(result);
                result = throwable;
            }
            return null;
        }
    }
}

