/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Resource;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class ProcessorStepTest {
    @Test
    public void shouldUpholdProcessOrderingGuarantee() throws Exception {
        StageControl control = (StageControl)Mockito.mock(StageControl.class);
        MyProcessorStep step = new MyProcessorStep(control);
        step.start(2);
        while (step.numberOfProcessors() < 5) {
            step.incrementNumberOfProcessors();
        }
        int batches = 10;
        for (int i = 0; i < batches; ++i) {
            step.receive(i, i);
        }
        step.endOfUpstream();
        while (!step.isCompleted()) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{control});
        }
        Assert.assertEquals((long)batches, (long)step.nextExpected.get());
        step.close();
    }

    public class MyProcessorStep
    extends ProcessorStep<Integer> {
        private final AtomicInteger nextExpected;

        private MyProcessorStep(StageControl control) {
            super(control, "test", Configuration.DEFAULT, 0, new StatsProvider[0]);
            this.nextExpected = new AtomicInteger();
        }

        protected Resource permit(Integer batch) throws Throwable {
            Thread.sleep(10L);
            Assert.assertEquals((long)this.nextExpected.getAndIncrement(), (long)batch.intValue());
            return super.permit((Object)batch);
        }

        protected void process(Integer batch, BatchSender sender) throws Throwable {
        }
    }
}

