/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class BatchingNeoStoresTest {
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private final File storeDir = new File("dir").getAbsoluteFile();

    @Test
    public void shouldNotOpenStoreWithNodesOrRelationshipsInIt() throws Exception {
        this.someDataInTheDatabase();
        try {
            new BatchingNeoStores((FileSystemAbstraction)this.fsr.get(), this.storeDir, Configuration.DEFAULT, (LogService)NullLogService.getInstance(), AdditionalInitialIds.EMPTY);
            Assert.fail((String)"Should fail on existing data");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"already contains"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void someDataInTheDatabase() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fsr.get()).newImpermanentDatabase(this.storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }
}

