/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import org.neo4j.cursor.Cursor;
import org.neo4j.function.Consumer;
import org.neo4j.kernel.api.cursor.PropertyItem;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.util.VersionedHashMap;

public abstract class TxAbstractPropertyCursor
implements Cursor<PropertyItem>,
PropertyItem {
    private final Consumer<TxAbstractPropertyCursor> instanceCache;
    protected Cursor<PropertyItem> cursor;
    protected VersionedHashMap<Integer, DefinedProperty> addedProperties;
    protected VersionedHashMap<Integer, DefinedProperty> changedProperties;
    protected VersionedHashMap<Integer, DefinedProperty> removedProperties;
    protected DefinedProperty property;

    public TxAbstractPropertyCursor(Consumer<TxAbstractPropertyCursor> instanceCache) {
        this.instanceCache = instanceCache;
    }

    public Cursor<PropertyItem> init(Cursor<PropertyItem> cursor, VersionedHashMap<Integer, DefinedProperty> addedProperties, VersionedHashMap<Integer, DefinedProperty> changedProperties, VersionedHashMap<Integer, DefinedProperty> removedProperties) {
        this.cursor = cursor;
        this.addedProperties = addedProperties;
        this.changedProperties = changedProperties;
        this.removedProperties = removedProperties;
        return this;
    }

    public PropertyItem get() {
        if (this.property == null) {
            throw new IllegalStateException();
        }
        return this;
    }

    public void close() {
        this.cursor.close();
        this.cursor = null;
        this.property = null;
        this.instanceCache.accept((Object)this);
    }

    @Override
    public int propertyKeyId() {
        return this.property.propertyKeyId();
    }

    @Override
    public Object value() {
        return this.property.value();
    }
}

