/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class Paths {
    public static <T extends Path> String pathToString(T path, PathDescriptor<T> builder) {
        Node current = path.startNode();
        StringBuilder result = new StringBuilder();
        for (Relationship rel : path.relationships()) {
            result.append(builder.nodeRepresentation(path, current));
            result.append(builder.relationshipRepresentation(path, current, rel));
            current = rel.getOtherNode(current);
        }
        if (null != current) {
            result.append(builder.nodeRepresentation(path, current));
        }
        return result.toString();
    }

    public static String defaultPathToString(Path path) {
        return Paths.pathToString(path, new DefaultPathDescriptor());
    }

    public static String simplePathToString(Path path) {
        return Paths.pathToString(path, new DefaultPathDescriptor<Path>(){

            @Override
            public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
                return relationship.getStartNode().equals(from) ? "-->" : "<--";
            }
        });
    }

    public static String simplePathToString(Path path, final String nodePropertyKey) {
        return Paths.pathToString(path, new DefaultPathDescriptor<Path>(){

            @Override
            public String nodeRepresentation(Path path, Node node) {
                return "(" + node.getProperty(nodePropertyKey, node.getId()) + ")";
            }

            @Override
            public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
                return relationship.getStartNode().equals(from) ? "-->" : "<--";
            }
        });
    }

    public static <T extends Path> PathDescriptor<T> descriptorForIdAndProperties(final boolean nodeId, final boolean relId, final String ... propertyKeys) {
        return new PathDescriptor<T>(){

            @Override
            public String nodeRepresentation(T path, Node node) {
                String representation = this.representation(node);
                return "(" + (nodeId ? Long.valueOf(node.getId()) : "") + (nodeId && !representation.equals("") ? "," : "") + representation + ")";
            }

            private String representation(PropertyContainer entity) {
                StringBuilder builder = new StringBuilder();
                for (String key : propertyKeys) {
                    Object value = entity.getProperty(key, null);
                    if (value == null) continue;
                    if (builder.length() > 0) {
                        builder.append(",");
                    }
                    builder.append(value);
                }
                return builder.toString();
            }

            @Override
            public String relationshipRepresentation(T path, Node from, Relationship relationship) {
                Direction direction = relationship.getEndNode().equals(from) ? Direction.INCOMING : Direction.OUTGOING;
                StringBuilder builder = new StringBuilder();
                if (direction.equals((Object)Direction.INCOMING)) {
                    builder.append("<");
                }
                builder.append("--[" + (relId ? Long.valueOf(relationship.getId()) : ""));
                String representation = this.representation(relationship);
                if (relId && !representation.equals("")) {
                    builder.append(",");
                }
                builder.append(representation);
                builder.append("]--");
                if (direction.equals((Object)Direction.OUTGOING)) {
                    builder.append(">");
                }
                return builder.toString();
            }
        };
    }

    public static class DefaultPathDescriptor<T extends Path>
    implements PathDescriptor<T> {
        @Override
        public String nodeRepresentation(Path path, Node node) {
            return "(" + node.getId() + ")";
        }

        @Override
        public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
            String prefix = "--";
            String suffix = "--";
            if (from.equals(relationship.getEndNode())) {
                prefix = "<--";
            } else {
                suffix = "-->";
            }
            return prefix + "[" + relationship.getType().name() + "," + relationship.getId() + "]" + suffix;
        }
    }

    public static interface PathDescriptor<T extends Path> {
        public String nodeRepresentation(T var1, Node var2);

        public String relationshipRepresentation(T var1, Node var2, Relationship var3);
    }
}

