/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.neo4j.helpers.Format;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.kernel.impl.util.OsBeanUtil;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.logging.Logger;

enum SystemDiagnostics implements DiagnosticsProvider
{
    SYSTEM_MEMORY("System memory information:"){

        @Override
        void dump(Logger logger) {
            SystemDiagnostics.logOsBeanValue(logger, "Total Physical memory: ", OsBeanUtil.getTotalPhysicalMemory());
            SystemDiagnostics.logOsBeanValue(logger, "Free Physical memory: ", OsBeanUtil.getFreePhysicalMemory());
            SystemDiagnostics.logOsBeanValue(logger, "Committed virtual memory: ", OsBeanUtil.getCommittedVirtualMemory());
            SystemDiagnostics.logOsBeanValue(logger, "Total swap space: ", OsBeanUtil.getTotalSwapSpace());
            SystemDiagnostics.logOsBeanValue(logger, "Free swap space: ", OsBeanUtil.getFreeSwapSpace());
        }
    }
    ,
    JAVA_MEMORY("JVM memory information:"){

        @Override
        void dump(Logger logger) {
            logger.log("Free  memory: " + Format.bytes(Runtime.getRuntime().freeMemory()));
            logger.log("Total memory: " + Format.bytes(Runtime.getRuntime().totalMemory()));
            logger.log("Max   memory: " + Format.bytes(Runtime.getRuntime().maxMemory()));
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                logger.log("Garbage Collector: " + gc.getName() + ": " + Arrays.toString(gc.getMemoryPoolNames()));
            }
            for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                MemoryUsage usage = pool.getUsage();
                logger.log(String.format("Memory Pool: %s (%s): committed=%s, used=%s, max=%s, threshold=%s", new Object[]{pool.getName(), pool.getType(), usage == null ? "?" : Format.bytes(usage.getCommitted()), usage == null ? "?" : Format.bytes(usage.getUsed()), usage == null ? "?" : Format.bytes(usage.getMax()), pool.isUsageThresholdSupported() ? Format.bytes(pool.getUsageThreshold()) : "?"}));
            }
        }
    }
    ,
    OPERATING_SYSTEM("Operating system information:"){

        @Override
        void dump(Logger logger) {
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            logger.log(String.format("Operating System: %s; version: %s; arch: %s; cpus: %s", os.getName(), os.getVersion(), os.getArch(), os.getAvailableProcessors()));
            SystemDiagnostics.logOsBeanValue(logger, "Max number of file descriptors: ", OsBeanUtil.getMaxFileDescriptors());
            SystemDiagnostics.logOsBeanValue(logger, "Number of open file descriptors: ", OsBeanUtil.getOpenFileDescriptors());
            logger.log("Process id: " + runtime.getName());
            logger.log("Byte order: " + ByteOrder.nativeOrder());
            logger.log("Local timezone: " + this.getLocalTimeZone());
        }

        private String getLocalTimeZone() {
            TimeZone tz = Calendar.getInstance().getTimeZone();
            return tz.getID();
        }
    }
    ,
    JAVA_VIRTUAL_MACHINE("JVM information:"){

        @Override
        void dump(Logger logger) {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            logger.log("VM Name: " + runtime.getVmName());
            logger.log("VM Vendor: " + runtime.getVmVendor());
            logger.log("VM Version: " + runtime.getVmVersion());
            CompilationMXBean compiler = ManagementFactory.getCompilationMXBean();
            logger.log("JIT compiler: " + (compiler == null ? "unknown" : compiler.getName()));
            logger.log("VM Arguments: " + runtime.getInputArguments());
        }
    }
    ,
    CLASSPATH("Java classpath:"){

        @Override
        void dump(Logger logger) {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            Collection<String> classpath = runtime.isBootClassPathSupported() ? this.buildClassPath(this.getClass().getClassLoader(), new String[]{"bootstrap", "classpath"}, runtime.getBootClassPath(), runtime.getClassPath()) : this.buildClassPath(this.getClass().getClassLoader(), new String[]{"classpath"}, runtime.getClassPath());
            for (String path : classpath) {
                logger.log(path);
            }
        }

        private Collection<String> buildClassPath(ClassLoader loader, String[] pathKeys, String ... classPaths) {
            HashMap<String, String> paths = new HashMap<String, String>();
            assert (pathKeys.length == classPaths.length);
            for (int i = 0; i < classPaths.length; ++i) {
                for (String path : classPaths[i].split(File.pathSeparator)) {
                    paths.put(SystemDiagnostics.canonicalize(path), this.pathValue(paths, pathKeys[i], path));
                }
            }
            int level = 0;
            while (loader != null) {
                if (loader instanceof URLClassLoader) {
                    URLClassLoader urls = (URLClassLoader)loader;
                    for (URL url : urls.getURLs()) {
                        if (!"file".equalsIgnoreCase(url.getProtocol())) continue;
                        paths.put(url.toString(), this.pathValue(paths, "loader." + level, url.getPath()));
                    }
                }
                loader = loader.getParent();
                ++level;
            }
            ArrayList<String> result = new ArrayList<String>(paths.size());
            for (Map.Entry path : paths.entrySet()) {
                result.add(" [" + (String)path.getValue() + "] " + (String)path.getKey());
            }
            return result;
        }

        private String pathValue(Map<String, String> paths, String key, String path) {
            String value = paths.remove(SystemDiagnostics.canonicalize(path));
            value = null != value ? value + " + " + key : key;
            return value;
        }
    }
    ,
    LIBRARY_PATH("Library path:"){

        @Override
        void dump(Logger logger) {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            for (String path : runtime.getLibraryPath().split(File.pathSeparator)) {
                logger.log(SystemDiagnostics.canonicalize(path));
            }
        }
    }
    ,
    SYSTEM_PROPERTIES("System.properties:"){

        @Override
        void dump(Logger logger) {
            for (Object property : System.getProperties().keySet()) {
                String key;
                if (!(property instanceof String) || (key = (String)property).startsWith("java.") || key.startsWith("os.") || key.endsWith(".boot.class.path") || key.equals("line.separator")) continue;
                logger.log(key + " = " + System.getProperty(key));
            }
        }
    }
    ,
    LINUX_SCHEDULERS("Linux scheduler information:"){
        private final File SYS_BLOCK = new File("/sys/block");

        @Override
        boolean isApplicable() {
            return this.SYS_BLOCK.isDirectory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void dump(Logger logger) {
            for (File subdir : this.SYS_BLOCK.listFiles(new FileFilter(){

                @Override
                public boolean accept(File path) {
                    return path.isDirectory();
                }
            })) {
                File scheduler = new File(subdir, "queue/scheduler");
                if (!scheduler.isFile()) continue;
                try (BufferedReader reader = FileUtils.newBufferedFileReader((File)scheduler, (Charset)Charsets.UTF_8);){
                    String line;
                    while (null != (line = reader.readLine())) {
                        logger.log(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
    ,
    NETWORK("Network information:"){

        @Override
        void dump(Logger logger) {
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface iface = networkInterfaces.nextElement();
                    logger.log(String.format("Interface %s:", iface.getDisplayName()));
                    Enumeration<InetAddress> addresses = iface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        String hostAddress = address.getHostAddress();
                        logger.log("    address: %s", new Object[]{hostAddress});
                    }
                }
            }
            catch (SocketException e) {
                logger.log("ERROR: failed to inspect network interfaces and addresses: " + e.getMessage());
            }
        }
    };

    private final String message;

    private SystemDiagnostics(String message) {
        this.message = message;
    }

    static void registerWith(DiagnosticsManager manager) {
        for (SystemDiagnostics provider : SystemDiagnostics.values()) {
            if (!provider.isApplicable()) continue;
            manager.appendProvider(provider);
        }
    }

    boolean isApplicable() {
        return true;
    }

    @Override
    public String getDiagnosticsIdentifier() {
        return this.name();
    }

    @Override
    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    @Override
    public void dump(DiagnosticsPhase phase, Logger logger) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            logger.log(this.message);
            this.dump(logger);
        }
    }

    abstract void dump(Logger var1);

    private static String canonicalize(String path) {
        try {
            return new File(path).getCanonicalFile().getAbsolutePath();
        }
        catch (IOException e) {
            return new File(path).getAbsolutePath();
        }
    }

    private static void logOsBeanValue(Logger logger, String message, long value) {
        if (value != -1L) {
            logger.log(message + Format.bytes(value));
        }
    }
}

