/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.net.URL;
import java.util.Map;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.security.FileURLAccessRule;
import org.neo4j.kernel.security.URLAccessValidationError;

public class URLAccessRules {
    private static final URLAccessRule ALWAYS_PERMITTED = new URLAccessRule(){

        @Override
        public URL validate(GraphDatabaseAPI gdb, URL url) {
            return url;
        }
    };
    private static final URLAccessRule FILE_ACCESS = new FileURLAccessRule();

    public static URLAccessRule alwaysPermitted() {
        return ALWAYS_PERMITTED;
    }

    public static URLAccessRule fileAccess() {
        return FILE_ACCESS;
    }

    public static URLAccessRule combined(final Map<String, URLAccessRule> urlAccessRules) {
        return new URLAccessRule(){

            @Override
            public URL validate(GraphDatabaseAPI gdb, URL url) throws URLAccessValidationError {
                String protocol = url.getProtocol();
                URLAccessRule protocolRule = (URLAccessRule)urlAccessRules.get(protocol);
                if (protocolRule == null) {
                    throw new URLAccessValidationError("loading resources via protocol '" + protocol + "' is not permitted");
                }
                return protocolRule.validate(gdb, url);
            }
        };
    }
}

