/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.logging.LogProvider;

public class StoreFactory {
    public static final String LABELS_PART = ".labels";
    public static final String NAMES_PART = ".names";
    public static final String INDEX_PART = ".index";
    public static final String KEYS_PART = ".keys";
    public static final String ARRAYS_PART = ".arrays";
    public static final String STRINGS_PART = ".strings";
    public static final String NODE_STORE_NAME = ".nodestore.db";
    public static final String NODE_LABELS_STORE_NAME = ".nodestore.db.labels";
    public static final String PROPERTY_STORE_NAME = ".propertystore.db";
    public static final String PROPERTY_KEY_TOKEN_STORE_NAME = ".propertystore.db.index";
    public static final String PROPERTY_KEY_TOKEN_NAMES_STORE_NAME = ".propertystore.db.index.keys";
    public static final String PROPERTY_STRINGS_STORE_NAME = ".propertystore.db.strings";
    public static final String PROPERTY_ARRAYS_STORE_NAME = ".propertystore.db.arrays";
    public static final String RELATIONSHIP_STORE_NAME = ".relationshipstore.db";
    public static final String RELATIONSHIP_TYPE_TOKEN_STORE_NAME = ".relationshiptypestore.db";
    public static final String RELATIONSHIP_TYPE_TOKEN_NAMES_STORE_NAME = ".relationshiptypestore.db.names";
    public static final String LABEL_TOKEN_STORE_NAME = ".labeltokenstore.db";
    public static final String LABEL_TOKEN_NAMES_STORE_NAME = ".labeltokenstore.db.names";
    public static final String SCHEMA_STORE_NAME = ".schemastore.db";
    public static final String RELATIONSHIP_GROUP_STORE_NAME = ".relationshipgroupstore.db";
    public static final String COUNTS_STORE = ".counts.db";
    private Config config;
    private IdGeneratorFactory idGeneratorFactory;
    private FileSystemAbstraction fileSystemAbstraction;
    private LogProvider logProvider;
    private File neoStoreFileName;
    private PageCache pageCache;

    public StoreFactory() {
    }

    public StoreFactory(FileSystemAbstraction fileSystem, File storeDir, PageCache pageCache, LogProvider logProvider) {
        this(storeDir, new Config(), new DefaultIdGeneratorFactory(fileSystem), pageCache, fileSystem, logProvider);
    }

    public StoreFactory(File storeDir, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, LogProvider logProvider) {
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.setLogProvider(logProvider);
        this.setStoreDir(storeDir);
        this.pageCache = pageCache;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setIdGeneratorFactory(IdGeneratorFactory idGeneratorFactory) {
        this.idGeneratorFactory = idGeneratorFactory;
    }

    public void setFileSystemAbstraction(FileSystemAbstraction fileSystemAbstraction) {
        this.fileSystemAbstraction = fileSystemAbstraction;
    }

    public void setLogProvider(LogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public void setStoreDir(File storeDir) {
        this.neoStoreFileName = new File(storeDir, "neostore");
    }

    public void setPageCache(PageCache pageCache) {
        this.pageCache = pageCache;
    }

    public NeoStores openAllNeoStores() {
        return this.openNeoStores(false, NeoStores.StoreType.values());
    }

    public NeoStores openAllNeoStores(boolean createStoreIfNotExists) {
        return this.openNeoStores(createStoreIfNotExists, NeoStores.StoreType.values());
    }

    public NeoStores openNeoStores(NeoStores.StoreType ... storeTypes) {
        return this.openNeoStores(false, storeTypes);
    }

    public NeoStores openNeoStores(boolean createStoreIfNotExists, NeoStores.StoreType ... storeTypes) {
        if (createStoreIfNotExists) {
            try {
                this.fileSystemAbstraction.mkdirs(this.neoStoreFileName.getParentFile());
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Could not create store directory: " + this.neoStoreFileName.getParent(), e);
            }
        }
        return new NeoStores(this.neoStoreFileName, this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, this.fileSystemAbstraction, createStoreIfNotExists, storeTypes);
    }

    public static abstract class Configuration {
        public static final Setting<Integer> string_block_size = GraphDatabaseSettings.string_block_size;
        public static final Setting<Integer> array_block_size = GraphDatabaseSettings.array_block_size;
    }
}

