/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIteratorBatcherStep;
import org.neo4j.unsafe.impl.batchimport.ParallelizeByNodeIdStep;
import org.neo4j.unsafe.impl.batchimport.PropertyEncoderStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipEncoderStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipPreparationStep;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class RelationshipStage
extends Stage {
    public RelationshipStage(Configuration config, IoMonitor writeMonitor, InputIterable<InputRelationship> relationships, IdMapper idMapper, BatchingNeoStores neoStore, NodeRelationshipCache cache, boolean specificIds, EntityStoreUpdaterStep.Monitor storeUpdateMonitor) {
        super("Relationships", config, 3);
        this.add(new InputIteratorBatcherStep<InputRelationship>(this.control(), config, relationships.iterator(), InputRelationship.class));
        RelationshipStore relationshipStore = neoStore.getRelationshipStore();
        PropertyStore propertyStore = neoStore.getPropertyStore();
        this.add(new RelationshipPreparationStep(this.control(), config, idMapper));
        this.add(new PropertyEncoderStep(this.control(), config, neoStore.getPropertyKeyRepository(), propertyStore));
        this.add(new ParallelizeByNodeIdStep(this.control(), config));
        this.add(new RelationshipEncoderStep(this.control(), config, neoStore.getRelationshipTypeRepository(), cache, specificIds));
        this.add(new EntityStoreUpdaterStep(this.control(), config, relationshipStore, propertyStore, writeMonitor, storeUpdateMonitor));
    }
}

