/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import org.neo4j.function.Consumer;
import org.neo4j.function.Predicate;
import org.neo4j.function.Supplier;

public class DelayedBuffer<T> {
    private final Supplier<T> thresholdSupplier;
    private final Predicate<T> safeThreshold;
    private final Consumer<long[]> chunkConsumer;
    private final Deque<Chunk> chunks = new LinkedList<Chunk>();
    private final int chunkSize;
    private final long[] chunk;
    private int chunkCursor;

    public DelayedBuffer(Supplier<T> thresholdSupplier, Predicate<T> safeThreshold, int chunkSize, Consumer<long[]> chunkConsumer) {
        this.thresholdSupplier = thresholdSupplier;
        this.safeThreshold = safeThreshold;
        this.chunkSize = chunkSize;
        this.chunkConsumer = chunkConsumer;
        this.chunk = new long[chunkSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintenance() {
        Object object = this;
        synchronized (object) {
            this.flush();
        }
        if (!this.chunks.isEmpty()) {
            object = this.chunks;
            synchronized (object) {
                Chunk candidate;
                while (!this.chunks.isEmpty() && this.safeThreshold.test((candidate = this.chunks.peek()).threshold)) {
                    this.chunkConsumer.accept((Object)candidate.values);
                    this.chunks.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        if (this.chunkCursor > 0) {
            Deque<Chunk> deque = this.chunks;
            synchronized (deque) {
                Chunk<Object> chunkToAdd = new Chunk<Object>(this.thresholdSupplier.get(), Arrays.copyOf(this.chunk, this.chunkCursor));
                this.chunks.offer(chunkToAdd);
            }
            this.chunkCursor = 0;
        }
    }

    public synchronized void offer(long value) {
        this.chunk[this.chunkCursor++] = value;
        if (this.chunkCursor == this.chunkSize) {
            this.flush();
        }
    }

    public synchronized void close() {
        this.flush();
        while (!this.chunks.isEmpty()) {
            this.chunkConsumer.accept((Object)this.chunks.poll().values);
        }
    }

    private static class Chunk<T> {
        private final T threshold;
        private final long[] values;

        Chunk(T threshold, long[] values) {
            this.threshold = threshold;
            this.values = values;
        }
    }
}

