/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyLogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;

public class ReadOnlyTransactionStore
extends LifecycleAdapter
implements LogicalTransactionStore {
    private final LifeSupport life = new LifeSupport();
    private final LogicalTransactionStore physicalStore;

    public ReadOnlyTransactionStore(PageCache pageCache, FileSystemAbstraction fs, File fromPath, Monitors monitors) throws IOException {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(fromPath, fs);
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache(10, 100);
        ReadOnlyTransactionIdStore transactionIdStore = new ReadOnlyTransactionIdStore(pageCache, fromPath);
        PhysicalLogFile logFile = this.life.add(new PhysicalLogFile(fs, logFiles, 0L, transactionIdStore, new ReadOnlyLogVersionRepository(pageCache, fromPath), monitors.newMonitor(PhysicalLogFile.Monitor.class, new String[0]), transactionMetadataCache));
        this.physicalStore = new PhysicalLogicalTransactionStore(logFile, transactionMetadataCache);
    }

    @Override
    public IOCursor<CommittedTransactionRepresentation> getTransactions(long transactionIdToStartFrom) throws NoSuchTransactionException, IOException {
        return this.physicalStore.getTransactions(transactionIdToStartFrom);
    }

    @Override
    public TransactionMetadataCache.TransactionMetadata getMetadataFor(long transactionId) throws NoSuchTransactionException, IOException {
        return this.physicalStore.getMetadataFor(transactionId);
    }

    @Override
    public void init() throws Throwable {
        this.life.init();
    }

    @Override
    public void start() throws Throwable {
        this.life.start();
    }

    @Override
    public void stop() throws Throwable {
        this.life.stop();
    }

    @Override
    public void shutdown() throws Throwable {
        this.life.shutdown();
    }
}

