/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Iterator;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RemoveOrphanConstraintIndexesOnStartup {
    private final Log log;
    private final KernelAPI kernel;

    public RemoveOrphanConstraintIndexesOnStartup(KernelAPI kernel, LogProvider logProvider) {
        this.kernel = kernel;
        this.log = logProvider.getLog(this.getClass());
    }

    public void perform() {
        try (KernelTransaction transaction = this.kernel.newTransaction();
             Statement statement = transaction.acquireStatement();){
            Iterator<IndexDescriptor> indexes = statement.readOperations().uniqueIndexesGetAll();
            while (indexes.hasNext()) {
                IndexDescriptor index = indexes.next();
                if (statement.readOperations().indexGetOwningUniquenessConstraintId(index) != null) continue;
                statement.schemaWriteOperations().uniqueIndexDrop(index);
            }
            transaction.success();
        }
        catch (KernelException e) {
            this.log.error("Failed to execute orphan index checking transaction.", (Throwable)e);
        }
    }
}

