/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;

public class ReaderLogVersionBridge
implements LogVersionBridge {
    private final FileSystemAbstraction fileSystem;
    private final PhysicalLogFiles logFiles;

    public ReaderLogVersionBridge(FileSystemAbstraction fileSystem, PhysicalLogFiles logFiles) {
        this.fileSystem = fileSystem;
        this.logFiles = logFiles;
    }

    @Override
    public LogVersionedStoreChannel next(LogVersionedStoreChannel channel) throws IOException {
        PhysicalLogVersionedStoreChannel nextChannel;
        try {
            nextChannel = PhysicalLogFile.openForVersion(this.logFiles, this.fileSystem, channel.getVersion() + 1L);
        }
        catch (FileNotFoundException e) {
            return channel;
        }
        channel.close();
        return nextChannel;
    }
}

