/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.function.Predicate;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.diffsets.DiffSetsVisitor;
import org.neo4j.kernel.impl.util.diffsets.SuperReadableDiffSets;

public interface ReadableRelationshipDiffSets<T>
extends SuperReadableDiffSets<T, RelationshipIterator> {
    public ReadableRelationshipDiffSets<T> filterAdded(Predicate<T> var1);

    public static final class Empty<T>
    implements ReadableRelationshipDiffSets<T> {
        private static final ReadableRelationshipDiffSets INSTANCE = new Empty();

        public static <T> ReadableRelationshipDiffSets<T> ifNull(ReadableRelationshipDiffSets<T> diffSets) {
            return diffSets == null ? INSTANCE : diffSets;
        }

        private Empty() {
        }

        @Override
        public boolean isAdded(T elem) {
            return false;
        }

        @Override
        public boolean isRemoved(T elem) {
            return false;
        }

        @Override
        public Set<T> getAdded() {
            return Collections.emptySet();
        }

        @Override
        public Set<T> getRemoved() {
            return Collections.emptySet();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<T> apply(Iterator<T> source) {
            return source;
        }

        @Override
        public int delta() {
            return 0;
        }

        @Override
        public RelationshipIterator augment(RelationshipIterator source) {
            return source;
        }

        @Override
        public PrimitiveIntIterator augment(PrimitiveIntIterator source) {
            return source;
        }

        @Override
        public RelationshipIterator augmentWithRemovals(RelationshipIterator source) {
            return source;
        }

        @Override
        public ReadableRelationshipDiffSets<T> filterAdded(Predicate<T> addedFilter) {
            return this;
        }

        @Override
        public void accept(DiffSetsVisitor<T> visitor) {
        }
    }
}

