/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import org.neo4j.unsafe.impl.batchimport.input.Group;

class IdGroup {
    private final Group group;
    private final int groupId;
    private final long lowDataIndex;
    private long highDataIndex = -1L;

    IdGroup(Group group, long lowDataIndex) {
        this.group = group;
        this.lowDataIndex = lowDataIndex;
        this.groupId = group.id();
    }

    void setHighDataIndex(long index) {
        this.highDataIndex = index;
    }

    boolean covers(long index) {
        return index >= this.lowDataIndex && index <= this.highDataIndex;
    }

    int id() {
        return this.groupId;
    }

    String name() {
        return this.group.name();
    }

    public String toString() {
        return this.group.toString();
    }
}

