/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.function.Supplier;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Provider;
import org.neo4j.helpers.collection.Iterables;

@Deprecated
public class Predicates {
    private static Predicate NOT_NULL = new Predicate(){

        public boolean accept(Object item) {
            return item != null;
        }
    };

    @Deprecated
    public static <T> Predicate<T> TRUE() {
        return new Predicate<T>(){

            @Override
            public boolean accept(T instance) {
                return true;
            }
        };
    }

    @Deprecated
    public static <T> Predicate<T> not(final Predicate<T> specification) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T instance) {
                return !specification.accept(instance);
            }
        };
    }

    @Deprecated
    public static <T> AndPredicate<T> and(Predicate<T> ... predicates) {
        return Predicates.and(Arrays.asList(predicates));
    }

    @Deprecated
    public static <T> AndPredicate<T> and(Iterable<Predicate<T>> predicates) {
        return new AndPredicate(predicates);
    }

    @Deprecated
    public static <T> OrPredicate<T> or(Predicate<T> ... predicates) {
        return Predicates.or(Arrays.asList(predicates));
    }

    @Deprecated
    public static <T> OrPredicate<T> or(Iterable<Predicate<T>> predicates) {
        return new OrPredicate(predicates);
    }

    @Deprecated
    public static <T> Predicate<T> equalTo(final T allowed) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T item) {
                return allowed == null ? item == null : allowed.equals(item);
            }
        };
    }

    @Deprecated
    public static <T> Predicate<T> in(T ... allowed) {
        return Predicates.in(Arrays.asList(allowed));
    }

    @Deprecated
    public static <T> Predicate<T> in(final Iterable<T> allowed) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T item) {
                for (Object allow : allowed) {
                    if (!allow.equals(item)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Deprecated
    public static <T> Predicate<T> in(final Collection<T> allowed) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T item) {
                return allowed.contains(item);
            }
        };
    }

    @Deprecated
    public static <T> Predicate<T> notNull() {
        return NOT_NULL;
    }

    @Deprecated
    public static <FROM, TO> Predicate<FROM> translate(final Function<FROM, TO> function, final Predicate<? super TO> specification) {
        return new Predicate<FROM>(){

            @Override
            public boolean accept(FROM item) {
                return specification.accept(function.apply(item));
            }
        };
    }

    @Deprecated
    public static <TYPE> void await(final Provider<TYPE> provider, Predicate<TYPE> predicate, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        Predicates.await(new Supplier<TYPE>(){

            public TYPE get() {
                return provider.instance();
            }
        }, predicate, timeout, unit);
    }

    @Deprecated
    public static <TYPE> void await(Supplier<TYPE> supplier, Predicate<TYPE> predicate, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        long sleep = Math.max(unit.toMillis(timeout) / 100L, 1L);
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        do {
            if (predicate.accept(supplier.get())) {
                return;
            }
            Thread.sleep(sleep);
        } while (System.currentTimeMillis() < deadline);
        throw new TimeoutException("Waited for " + timeout + " " + (Object)((Object)unit) + ", but " + predicate + " was not accepted.");
    }

    @Deprecated
    public static Predicate<String> stringContains(final String string) {
        return new Predicate<String>(){

            @Override
            public boolean accept(String item) {
                return item.contains(string);
            }
        };
    }

    @Deprecated
    public static <T> Predicate<T> instanceOf(final Class clazz) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T item) {
                return item != null && clazz.isInstance(item);
            }
        };
    }

    public static <T> org.neo4j.function.Predicate<T> upgrade(final Predicate<T> oldPredicate) {
        return new org.neo4j.function.Predicate<T>(){

            public boolean test(T item) {
                return oldPredicate.accept(item);
            }
        };
    }

    @Deprecated
    public static class OrPredicate<T>
    implements Predicate<T> {
        private final Iterable<Predicate<T>> predicates;

        private OrPredicate(Iterable<Predicate<T>> predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean accept(T instance) {
            for (Predicate<T> specification : this.predicates) {
                if (!specification.accept(instance)) continue;
                return true;
            }
            return false;
        }

        public AndPredicate<T> and(Predicate<T> ... predicates) {
            return Predicates.and(Iterables.prepend(this, Arrays.asList(predicates)));
        }

        public OrPredicate<T> or(Predicate<T> ... predicates) {
            Iterable iterable = Iterables.iterable(predicates);
            Iterable flatten = Iterables.flatten((Iterable[])new Iterable[]{this.predicates, iterable});
            return Predicates.or(flatten);
        }
    }

    @Deprecated
    public static class AndPredicate<T>
    implements Predicate<T> {
        private final Iterable<Predicate<T>> predicates;

        private AndPredicate(Iterable<Predicate<T>> predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean accept(T instance) {
            for (Predicate<T> specification : this.predicates) {
                if (specification.accept(instance)) continue;
                return false;
            }
            return true;
        }

        public AndPredicate<T> and(Predicate<T> ... predicates) {
            Iterable iterable = Iterables.iterable(predicates);
            Iterable flatten = Iterables.flatten((Iterable[])new Iterable[]{this.predicates, iterable});
            return Predicates.and(flatten);
        }

        public OrPredicate<T> or(Predicate<T> ... predicates) {
            return Predicates.or(Iterables.prepend(this, Arrays.asList(predicates)));
        }
    }
}

