/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.function.Consumer;
import org.neo4j.function.Function;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.ProcedureConstraintViolation;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.procedures.ProcedureDescriptor;
import org.neo4j.kernel.api.procedures.ProcedureSignature;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.TwoPhaseNodeForRelationshipLocking;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.LockOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.store.SchemaStorage;

public class LockingStatementOperations
implements EntityWriteOperations,
SchemaReadOperations,
SchemaWriteOperations,
SchemaStateOperations,
LockOperations {
    private final EntityReadOperations entityReadDelegate;
    private final EntityWriteOperations entityWriteDelegate;
    private final SchemaReadOperations schemaReadDelegate;
    private final SchemaWriteOperations schemaWriteDelegate;
    private final SchemaStateOperations schemaStateDelegate;

    public LockingStatementOperations(EntityReadOperations entityReadDelegate, EntityWriteOperations entityWriteDelegate, SchemaReadOperations schemaReadDelegate, SchemaWriteOperations schemaWriteDelegate, SchemaStateOperations schemaStateDelegate) {
        this.entityReadDelegate = entityReadDelegate;
        this.entityWriteDelegate = entityWriteDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.schemaWriteDelegate = schemaWriteDelegate;
        this.schemaStateDelegate = schemaStateDelegate;
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws ConstraintValidationKernelException, EntityNotFoundException {
        this.acquireSharedSchemaLock(state);
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        return this.entityWriteDelegate.nodeAddLabel(state, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        return this.entityWriteDelegate.nodeRemoveLabel(state, nodeId, labelId);
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, int labelId, int propertyKey) throws AlreadyIndexedException, AlreadyConstrainedException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        return this.schemaWriteDelegate.indexCreate(state, labelId, propertyKey);
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        this.schemaWriteDelegate.indexDrop(state, descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        this.schemaWriteDelegate.uniqueIndexDrop(state, descriptor);
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(KernelStatement state, K key, Function<K, V> creator) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaStateDelegate.schemaStateGetOrCreate(state, key, creator);
    }

    @Override
    public <K> boolean schemaStateContains(KernelStatement state, K key) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaStateDelegate.schemaStateContains(state, key);
    }

    @Override
    public void schemaStateFlush(KernelStatement state) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        this.schemaStateDelegate.schemaStateFlush(state);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexesGetForLabel(state, labelId);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKey) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexesGetForLabelAndPropertyKey(state, labelId, propertyKey);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexesGetAll(state);
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexGetState(state, descriptor);
    }

    @Override
    public long indexSize(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexSize(state, descriptor);
    }

    @Override
    public double indexUniqueValuesPercentage(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexUniqueValuesPercentage(state, descriptor);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexGetOwningUniquenessConstraintId(state, index);
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index, SchemaStorage.IndexRuleKind kind) throws SchemaRuleNotFoundException {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexGetCommittedId(state, index, kind);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(KernelStatement state, int labelId) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.uniqueIndexesGetForLabel(state, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(KernelStatement state) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.uniqueIndexesGetAll(state);
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        this.entityWriteDelegate.nodeDelete(state, nodeId);
    }

    @Override
    public int nodeDetachDelete(final KernelStatement state, long nodeId) throws EntityNotFoundException {
        final MutableInt count = new MutableInt();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking(this.entityReadDelegate, new Consumer<Long>(){

            public void accept(Long relId) {
                state.assertOpen();
                try {
                    LockingStatementOperations.this.entityWriteDelegate.relationshipDelete(state, relId);
                    count.increment();
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    // empty catch block
                }
            }
        });
        locking.lockAllNodesAndConsumeRelationships(nodeId, state);
        state.assertOpen();
        this.entityWriteDelegate.nodeDetachDelete(state, nodeId);
        return count.intValue();
    }

    @Override
    public long nodeCreate(KernelStatement statement) {
        return this.entityWriteDelegate.nodeCreate(statement);
    }

    @Override
    public long relationshipCreate(KernelStatement state, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        this.acquireSharedSchemaLock(state);
        this.lockRelationshipNodes(state, startNodeId, endNodeId);
        return this.entityWriteDelegate.relationshipCreate(state, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public void relationshipDelete(final KernelStatement state, long relationshipId) throws EntityNotFoundException {
        this.entityReadDelegate.relationshipVisit(state, relationshipId, new RelationshipVisitor<RuntimeException>(){

            @Override
            public void visit(long relId, int type, long startNode, long endNode) {
                LockingStatementOperations.this.lockRelationshipNodes(state, startNode, endNode);
            }
        });
        this.acquireExclusiveRelationshipLock(state, relationshipId);
        state.assertOpen();
        this.entityWriteDelegate.relationshipDelete(state, relationshipId);
    }

    private void lockRelationshipNodes(KernelStatement state, long startNodeId, long endNodeId) {
        this.acquireExclusiveNodeLock(state, Math.min(startNodeId, endNodeId));
        if (startNodeId != endNodeId) {
            this.acquireExclusiveNodeLock(state, Math.max(startNodeId, endNodeId));
        }
    }

    @Override
    public UniquenessConstraint uniquePropertyConstraintCreate(KernelStatement state, int labelId, int propertyKeyId) throws CreateConstraintFailureException, AlreadyConstrainedException, AlreadyIndexedException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        return this.schemaWriteDelegate.uniquePropertyConstraintCreate(state, labelId, propertyKeyId);
    }

    @Override
    public NodePropertyExistenceConstraint nodePropertyExistenceConstraintCreate(KernelStatement state, int labelId, int propertyKeyId) throws AlreadyConstrainedException, CreateConstraintFailureException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        return this.schemaWriteDelegate.nodePropertyExistenceConstraintCreate(state, labelId, propertyKeyId);
    }

    @Override
    public RelationshipPropertyExistenceConstraint relationshipPropertyExistenceConstraintCreate(KernelStatement state, int relTypeId, int propertyKeyId) throws AlreadyConstrainedException, CreateConstraintFailureException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        return this.schemaWriteDelegate.relationshipPropertyExistenceConstraintCreate(state, relTypeId, propertyKeyId);
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKeyId) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKeyId);
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabel(KernelStatement state, int labelId) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetForLabel(state, labelId);
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipTypeAndPropertyKey(KernelStatement state, int relTypeId, int propertyKeyId) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetForRelationshipTypeAndPropertyKey(state, relTypeId, propertyKeyId);
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipType(KernelStatement state, int typeId) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetForRelationshipType(state, typeId);
    }

    @Override
    public Iterator<PropertyConstraint> constraintsGetAll(KernelStatement state) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetAll(state);
    }

    @Override
    public void constraintDrop(KernelStatement state, NodePropertyConstraint constraint) throws DropConstraintFailureException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        this.schemaWriteDelegate.constraintDrop(state, constraint);
    }

    @Override
    public void constraintDrop(KernelStatement state, RelationshipPropertyConstraint constraint) throws DropConstraintFailureException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        this.schemaWriteDelegate.constraintDrop(state, constraint);
    }

    @Override
    public void procedureCreate(KernelStatement state, ProcedureSignature signature, String language, String code) throws ProcedureException, ProcedureConstraintViolation {
        state.locks().optimistic().acquireExclusive(ResourceTypes.PROCEDURE, ResourceTypes.procedureResourceId(signature.name()));
        this.schemaWriteDelegate.procedureCreate(state, signature, language, code);
    }

    @Override
    public void procedureDrop(KernelStatement state, ProcedureSignature.ProcedureName name) throws ProcedureConstraintViolation, ProcedureException {
        this.acquireExclusiveSchemaLock(state);
        state.locks().optimistic().acquireExclusive(ResourceTypes.PROCEDURE, ResourceTypes.procedureResourceId(name));
        this.schemaWriteDelegate.procedureDrop(state, name);
    }

    @Override
    public Iterator<ProcedureDescriptor> proceduresGetAll(KernelStatement statement) {
        return this.schemaReadDelegate.proceduresGetAll(statement);
    }

    @Override
    public ProcedureDescriptor procedureGet(KernelStatement statement, ProcedureSignature.ProcedureName signature) throws ProcedureException {
        return this.schemaReadDelegate.procedureGet(statement, signature);
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws ConstraintValidationKernelException, EntityNotFoundException {
        this.acquireSharedSchemaLock(state);
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        return this.entityWriteDelegate.nodeSetProperty(state, nodeId, property);
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        return this.entityWriteDelegate.nodeRemoveProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException {
        this.acquireExclusiveRelationshipLock(state, relationshipId);
        state.assertOpen();
        return this.entityWriteDelegate.relationshipSetProperty(state, relationshipId, property);
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        this.acquireExclusiveRelationshipLock(state, relationshipId);
        state.assertOpen();
        return this.entityWriteDelegate.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        state.locks().optimistic().acquireExclusive(ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        state.assertOpen();
        return this.entityWriteDelegate.graphSetProperty(state, property);
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        state.locks().optimistic().acquireExclusive(ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        state.assertOpen();
        return this.entityWriteDelegate.graphRemoveProperty(state, propertyKeyId);
    }

    @Override
    public void acquireExclusive(KernelStatement state, Locks.ResourceType resourceType, long resourceId) {
        state.locks().pessimistic().acquireExclusive(resourceType, resourceId);
        state.assertOpen();
    }

    @Override
    public void acquireShared(KernelStatement state, Locks.ResourceType resourceType, long resourceId) {
        state.locks().pessimistic().acquireShared(resourceType, resourceId);
        state.assertOpen();
    }

    @Override
    public void releaseExclusive(KernelStatement state, Locks.ResourceType type, long resourceId) {
        state.locks().pessimistic().releaseExclusive(type, resourceId);
        state.assertOpen();
    }

    @Override
    public void releaseShared(KernelStatement state, Locks.ResourceType type, long resourceId) {
        state.locks().pessimistic().releaseShared(type, resourceId);
        state.assertOpen();
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.schemaReadDelegate.indexGetFailure(state, descriptor);
    }

    private void acquireExclusiveNodeLock(KernelStatement state, long nodeId) {
        if (!state.txState().nodeIsAddedInThisTx(nodeId)) {
            state.locks().optimistic().acquireExclusive(ResourceTypes.NODE, nodeId);
        }
    }

    private void acquireExclusiveRelationshipLock(KernelStatement state, long relationshipId) {
        if (!state.txState().relationshipIsAddedInThisTx(relationshipId)) {
            state.locks().optimistic().acquireExclusive(ResourceTypes.RELATIONSHIP, relationshipId);
        }
    }

    private void acquireSharedSchemaLock(KernelStatement state) {
        state.locks().optimistic().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
    }

    private void acquireExclusiveSchemaLock(KernelStatement state) {
        state.locks().optimistic().acquireExclusive(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
    }
}

