/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.LongFunction;
import org.neo4j.function.primitive.FunctionFromPrimitiveLong;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.StoreLocker;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.UniquenessConstraintDefinition;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.logging.StoreLogService;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.spi.SimpleKernelContext;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodePropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.kernel.impl.transaction.state.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.transaction.state.PropertyDeleter;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreator;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.udc.UsageDataKeys;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchRelationship;
import org.neo4j.unsafe.batchinsert.BatchRelationshipIterable;
import org.neo4j.unsafe.batchinsert.BatchTokenHolder;
import org.neo4j.unsafe.batchinsert.DirectRecordAccessSet;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

@Deprecated
public class BatchInserterImpl
implements BatchInserter {
    private static final long MAX_NODE_ID = IdType.NODE.getMaxValue();
    private final LifeSupport life;
    private final NeoStores neoStores;
    private final IndexConfigStore indexStore;
    private final File storeDir;
    private final BatchTokenHolder propertyKeyTokens;
    private final BatchTokenHolder relationshipTypeTokens;
    private final BatchTokenHolder labelTokens;
    private final IdGeneratorFactory idGeneratorFactory;
    private final SchemaIndexProviderMap schemaIndexProviders;
    private final LabelScanStore labelScanStore;
    private final Log msgLog;
    private final SchemaCache schemaCache;
    private final Config config;
    private final BatchSchemaActions actions;
    private final StoreLocker storeLocker;
    private boolean labelsTouched;
    private final LongFunction<Label> labelIdToLabelFunction = new LongFunction<Label>(){

        public Label apply(long from) {
            return DynamicLabel.label(BatchInserterImpl.this.labelTokens.byId(IoPrimitiveUtils.safeCastLongToInt(from)).name());
        }
    };
    private boolean isShutdown = false;
    private FlushStrategy flushStrategy;
    private final RelationshipCreator relationshipCreator;
    private final DirectRecordAccessSet recordAccess;
    private final PropertyTraverser propertyTraverser;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeletor;
    private NodeStore nodeStore;
    private RelationshipStore relationshipStore;
    private RelationshipTypeTokenStore relationshipTypeTokenStore;
    private PropertyKeyTokenStore propertyKeyTokenStore;
    private PropertyStore propertyStore;
    private RelationshipGroupStore relationshipGroupStore;
    private SchemaStore schemaStore;
    private LabelTokenStore labelTokenStore;

    @Deprecated
    BatchInserterImpl(String storeDir, Map<String, String> stringParams) throws IOException {
        this(new File(FileUtils.fixSeparatorsInPath((String)storeDir)), stringParams);
    }

    @Deprecated
    BatchInserterImpl(String storeDir, FileSystemAbstraction fileSystem, Map<String, String> stringParams, Iterable<KernelExtensionFactory<?>> kernelExtensions) throws IOException {
        this(new File(FileUtils.fixSeparatorsInPath((String)storeDir)), fileSystem, stringParams, kernelExtensions);
    }

    BatchInserterImpl(File storeDir, Map<String, String> stringParams) throws IOException {
        this(storeDir, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), stringParams, Collections.emptyList());
    }

    BatchInserterImpl(File storeDir, FileSystemAbstraction fileSystem, Map<String, String> stringParams, Iterable<KernelExtensionFactory<?>> kernelExtensions) throws IOException {
        this.rejectAutoUpgrade(stringParams);
        Map<String, String> params = this.getDefaultParams();
        params.putAll(stringParams);
        this.config = new Config(params, GraphDatabaseSettings.class);
        this.life = new LifeSupport();
        this.storeDir = storeDir;
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, this.config, PageCacheTracer.NULL, (Log)NullLog.getInstance());
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        this.life.add(new PageCacheLifecycle(pageCache));
        StoreLogService logService = this.life.add(StoreLogService.inStoreDirectory(fileSystem, this.storeDir));
        this.msgLog = logService.getInternalLog(this.getClass());
        this.storeLocker = new StoreLocker(fileSystem);
        this.storeLocker.checkLock(this.storeDir);
        boolean dump = this.config.get(GraphDatabaseSettings.dump_configuration);
        this.idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem);
        StoreFactory sf = new StoreFactory(this.storeDir, this.config, this.idGeneratorFactory, pageCache, fileSystem, logService.getInternalLogProvider());
        if (dump) {
            this.dumpConfiguration(params, System.out);
        }
        this.msgLog.info(Thread.currentThread() + " Starting BatchInserter(" + this + ")");
        this.life.start();
        this.neoStores = sf.openAllNeoStores(true);
        this.neoStores.verifyStoreOk();
        this.nodeStore = this.neoStores.getNodeStore();
        this.relationshipStore = this.neoStores.getRelationshipStore();
        this.relationshipTypeTokenStore = this.neoStores.getRelationshipTypeTokenStore();
        this.propertyKeyTokenStore = this.neoStores.getPropertyKeyTokenStore();
        this.propertyStore = this.neoStores.getPropertyStore();
        this.relationshipGroupStore = this.neoStores.getRelationshipGroupStore();
        this.schemaStore = this.neoStores.getSchemaStore();
        this.labelTokenStore = this.neoStores.getLabelTokenStore();
        List indexes = this.propertyKeyTokenStore.getTokens(10000);
        this.propertyKeyTokens = new BatchTokenHolder(indexes);
        this.labelTokens = new BatchTokenHolder(this.labelTokenStore.getTokens(Integer.MAX_VALUE));
        List types = this.relationshipTypeTokenStore.getTokens(Integer.MAX_VALUE);
        this.relationshipTypeTokens = new BatchTokenHolder(types);
        this.indexStore = this.life.add(new IndexConfigStore(this.storeDir, fileSystem));
        this.schemaCache = new SchemaCache(new StandardConstraintSemantics(), this.schemaStore);
        Dependencies deps = new Dependencies();
        deps.satisfyDependencies(fileSystem, this.config, logService, new NeoStoresSupplier(){

            public NeoStores get() {
                return BatchInserterImpl.this.neoStores;
            }
        });
        SimpleKernelContext kernelContext = new SimpleKernelContext(fileSystem, storeDir, UsageDataKeys.OperationalMode.single);
        KernelExtensions extensions = this.life.add(new KernelExtensions(kernelContext, kernelExtensions, deps, UnsatisfiedDependencyStrategies.ignore()));
        SchemaIndexProvider provider = extensions.resolveDependency(SchemaIndexProvider.class, SchemaIndexProvider.HIGHEST_PRIORITIZED_OR_NONE);
        this.schemaIndexProviders = new DefaultSchemaIndexProviderMap(provider);
        this.labelScanStore = this.life.add(extensions.resolveDependency(LabelScanStoreProvider.class, LabelScanStoreProvider.HIGHEST_PRIORITIZED).getLabelScanStore());
        this.actions = new BatchSchemaActions();
        this.recordAccess = new DirectRecordAccessSet(this.neoStores);
        this.relationshipCreator = new RelationshipCreator(new NoOpClient(), new RelationshipGroupGetter(this.relationshipGroupStore), this.relationshipGroupStore.getDenseNodeThreshold());
        this.propertyTraverser = new PropertyTraverser();
        this.propertyCreator = new PropertyCreator(this.propertyStore, this.propertyTraverser);
        this.propertyDeletor = new PropertyDeleter(this.propertyStore, this.propertyTraverser);
        this.flushStrategy = new BatchedFlushStrategy(this.recordAccess, this.config.get(GraphDatabaseSettings.batch_inserter_batch_size));
    }

    private Map<String, String> getDefaultParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GraphDatabaseSettings.pagecache_memory.name(), "32m");
        return params;
    }

    @Override
    public boolean nodeHasProperty(long node, String propertyName) {
        return this.primitiveHasProperty(this.getNodeRecord(node).forChangingData(), propertyName);
    }

    @Override
    public boolean relationshipHasProperty(long relationship, String propertyName) {
        return this.primitiveHasProperty(this.recordAccess.getRelRecords().getOrLoad(relationship, null).forReadingData(), propertyName);
    }

    @Override
    public void setNodeProperty(long node, String propertyName, Object propertyValue) {
        RecordAccess.RecordProxy<Long, NodeRecord, Void> nodeRecord = this.getNodeRecord(node);
        this.setPrimitiveProperty(nodeRecord, propertyName, propertyValue);
        this.flushStrategy.flush();
    }

    @Override
    public void setRelationshipProperty(long relationship, String propertyName, Object propertyValue) {
        RecordAccess.RecordProxy<Long, RelationshipRecord, Void> relationshipRecord = this.getRelationshipRecord(relationship);
        this.setPrimitiveProperty(relationshipRecord, propertyName, propertyValue);
        this.flushStrategy.flush();
    }

    @Override
    public void removeNodeProperty(long node, String propertyName) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        this.propertyDeletor.removeProperty(this.getNodeRecord(node), propertyKey, this.recordAccess.getPropertyRecords());
        this.flushStrategy.flush();
    }

    @Override
    public void removeRelationshipProperty(long relationship, String propertyName) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        this.propertyDeletor.removeProperty(this.getRelationshipRecord(relationship), propertyKey, this.recordAccess.getPropertyRecords());
        this.flushStrategy.flush();
    }

    @Override
    public IndexCreator createDeferredSchemaIndex(Label label) {
        return new IndexCreatorImpl(this.actions, label);
    }

    private void setPrimitiveProperty(RecordAccess.RecordProxy<Long, ? extends PrimitiveRecord, Void> primitiveRecord, String propertyName, Object propertyValue) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords = this.recordAccess.getPropertyRecords();
        this.propertyCreator.primitiveSetProperty(primitiveRecord, propertyKey, propertyValue, propertyRecords);
    }

    private void validateIndexCanBeCreated(int labelId, int propertyKeyId) {
        this.verifyIndexOrUniquenessConstraintCanBeCreated(labelId, propertyKeyId, "Index for given {label;property} already exists");
    }

    private void validateUniquenessConstraintCanBeCreated(int labelId, int propertyKeyId) {
        this.verifyIndexOrUniquenessConstraintCanBeCreated(labelId, propertyKeyId, "It is not allowed to create uniqueness constraints and indexes on the same {label;property}");
    }

    private void verifyIndexOrUniquenessConstraintCanBeCreated(int labelId, int propertyKeyId, String errorMessage) {
        block5: for (SchemaRule rule : this.schemaCache.schemaRulesForLabel(labelId)) {
            int otherPropertyKeyId;
            switch (rule.getKind()) {
                case INDEX_RULE: 
                case CONSTRAINT_INDEX_RULE: {
                    otherPropertyKeyId = ((IndexRule)rule).getPropertyKey();
                    break;
                }
                case UNIQUENESS_CONSTRAINT: {
                    otherPropertyKeyId = ((UniquePropertyConstraintRule)rule).getPropertyKey();
                    break;
                }
                case NODE_PROPERTY_EXISTENCE_CONSTRAINT: {
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Case not handled for " + (Object)((Object)rule.getKind()));
                }
            }
            if (otherPropertyKeyId != propertyKeyId) continue;
            throw new ConstraintViolationException(errorMessage);
        }
    }

    private void validateNodePropertyExistenceConstraintCanBeCreated(int labelId, int propertyKeyId) {
        for (SchemaRule rule : this.schemaCache.schemaRulesForLabel(labelId)) {
            if (rule.getKind() != SchemaRule.Kind.NODE_PROPERTY_EXISTENCE_CONSTRAINT || propertyKeyId != ((NodePropertyExistenceConstraintRule)rule).getPropertyKey()) continue;
            throw new ConstraintViolationException("Node property existence constraint for given {label;property} already exists");
        }
    }

    private void validateRelationshipConstraintCanBeCreated(int typeId, int propertyKeyId) {
        for (SchemaRule rule : this.schemaCache.schemaRulesForRelationshipType(typeId)) {
            if (rule.getKind() != SchemaRule.Kind.RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT || propertyKeyId != ((RelationshipPropertyExistenceConstraintRule)rule).getPropertyKey()) continue;
            throw new ConstraintViolationException("Relationship property existence constraint for given {type;property} already exists");
        }
    }

    private void createIndexRule(int labelId, int propertyKeyId) {
        IndexRule schemaRule = IndexRule.indexRule(this.schemaStore.nextId(), labelId, propertyKeyId, this.schemaIndexProviders.getDefaultProvider().getProviderDescriptor());
        for (DynamicRecord record : this.schemaStore.allocateFrom(schemaRule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(schemaRule);
        this.labelsTouched = true;
        this.flushStrategy.forceFlush();
    }

    private void repopulateAllIndexes() throws IOException, IndexCapacityExceededException, IndexEntryConflictException {
        if (!this.labelsTouched) {
            return;
        }
        final IndexRule[] rules = this.getIndexesNeedingPopulation();
        final IndexPopulator[] populators = new IndexPopulator[rules.length];
        ReentrantLockService locks = new ReentrantLockService();
        NeoStoreIndexStoreView storeView = new NeoStoreIndexStoreView(locks, this.neoStores);
        final int[] labelIds = new int[rules.length];
        final int[] propertyKeyIds = new int[rules.length];
        for (int i = 0; i < labelIds.length; ++i) {
            IndexRule rule = rules[i];
            int labelId = rule.getLabel();
            int propertyKeyId = rule.getPropertyKey();
            labelIds[i] = labelId;
            propertyKeyIds[i] = propertyKeyId;
            IndexDescriptor descriptor = new IndexDescriptor(labelId, propertyKeyId);
            boolean isConstraint = rule.isConstraintIndex();
            populators[i] = this.schemaIndexProviders.apply(rule.getProviderDescriptor()).getPopulator(rule.getId(), descriptor, new IndexConfiguration(isConstraint), new IndexSamplingConfig(this.config));
            populators[i].create();
        }
        Visitor<NodePropertyUpdate, IOException> propertyUpdateVisitor = new Visitor<NodePropertyUpdate, IOException>(){

            @Override
            public boolean visit(NodePropertyUpdate update) throws IOException {
                int propertyKeyInQuestion = update.getPropertyKeyId();
                for (int i = 0; i < propertyKeyIds.length; ++i) {
                    if (propertyKeyIds[i] != propertyKeyInQuestion || !update.forLabel(labelIds[i])) continue;
                    try {
                        populators[i].add(update.getNodeId(), update.getValueAfter());
                        continue;
                    }
                    catch (IndexEntryConflictException conflict) {
                        throw conflict.notAllowed(rules[i].getLabel(), rules[i].getPropertyKey());
                    }
                    catch (IndexCapacityExceededException e) {
                        throw new UnderlyingStorageException(e);
                    }
                }
                return true;
            }
        };
        InitialNodeLabelCreationVisitor labelUpdateVisitor = new InitialNodeLabelCreationVisitor();
        StoreScan<IOException> storeScan = storeView.visitNodes(labelIds, propertyKeyIds, propertyUpdateVisitor, labelUpdateVisitor);
        storeScan.run();
        for (IndexPopulator populator : populators) {
            populator.verifyDeferredConstraints(storeView);
            populator.close(true);
        }
        labelUpdateVisitor.close();
    }

    private void rebuildCounts() {
        CountsTracker counts = this.neoStores.getCounts();
        try {
            counts.start();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        CountsComputer.recomputeCounts(this.neoStores);
    }

    private IndexRule[] getIndexesNeedingPopulation() {
        ArrayList<IndexRule> indexesNeedingPopulation = new ArrayList<IndexRule>();
        for (SchemaRule rule : this.schemaCache.schemaRules()) {
            IndexRule indexRule;
            SchemaIndexProvider provider;
            if (!rule.getKind().isIndex() || (provider = this.schemaIndexProviders.apply((indexRule = (IndexRule)rule).getProviderDescriptor())).getInitialState(indexRule.getId()) == InternalIndexState.FAILED) continue;
            indexesNeedingPopulation.add(indexRule);
        }
        return indexesNeedingPopulation.toArray(new IndexRule[indexesNeedingPopulation.size()]);
    }

    @Override
    public ConstraintCreator createDeferredConstraint(Label label) {
        return new BaseNodeConstraintCreator(new BatchSchemaActions(), label);
    }

    private void createConstraintRule(UniquenessConstraint constraint) {
        long indexRuleId = this.schemaStore.nextId();
        long constraintRuleId = this.schemaStore.nextId();
        IndexRule indexRule = IndexRule.constraintIndexRule(indexRuleId, constraint.label(), constraint.propertyKey(), this.schemaIndexProviders.getDefaultProvider().getProviderDescriptor(), constraintRuleId);
        UniquePropertyConstraintRule constraintRule = UniquePropertyConstraintRule.uniquenessConstraintRule(constraintRuleId, constraint.label(), constraint.propertyKey(), indexRuleId);
        for (DynamicRecord record : this.schemaStore.allocateFrom(constraintRule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(constraintRule);
        for (DynamicRecord record : this.schemaStore.allocateFrom(indexRule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(indexRule);
        this.labelsTouched = true;
        this.flushStrategy.forceFlush();
    }

    private void createConstraintRule(NodePropertyExistenceConstraint constraint) {
        NodePropertyExistenceConstraintRule rule = NodePropertyExistenceConstraintRule.nodePropertyExistenceConstraintRule(this.schemaStore.nextId(), constraint.label(), constraint.propertyKey());
        for (DynamicRecord record : this.schemaStore.allocateFrom(rule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(rule);
        this.labelsTouched = true;
        this.flushStrategy.forceFlush();
    }

    private void createConstraintRule(RelationshipPropertyExistenceConstraint constraint) {
        RelationshipPropertyExistenceConstraintRule rule = RelationshipPropertyExistenceConstraintRule.relPropertyExistenceConstraintRule(this.schemaStore.nextId(), constraint.relationshipType(), constraint.propertyKey());
        for (DynamicRecord record : this.schemaStore.allocateFrom(rule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(rule);
        this.flushStrategy.forceFlush();
    }

    private int getOrCreatePropertyKeyId(String name) {
        int propertyKeyId = this.tokenIdByName(this.propertyKeyTokens, name);
        if (propertyKeyId == -1) {
            propertyKeyId = this.createNewPropertyKeyId(name);
        }
        return propertyKeyId;
    }

    private int getOrCreateRelationshipTypeToken(RelationshipType type) {
        int typeId = this.tokenIdByName(this.relationshipTypeTokens, type.name());
        if (typeId == -1) {
            typeId = this.createNewRelationshipType(type.name());
        }
        return typeId;
    }

    private int getOrCreateLabelId(String name) {
        int labelId = this.tokenIdByName(this.labelTokens, name);
        if (labelId == -1) {
            labelId = this.createNewLabelId(name);
        }
        return labelId;
    }

    private int getOrCreateRelationshipTypeId(String name) {
        int relationshipTypeId = this.tokenIdByName(this.relationshipTypeTokens, name);
        if (relationshipTypeId == -1) {
            relationshipTypeId = this.createNewRelationshipType(name);
        }
        return relationshipTypeId;
    }

    private int tokenIdByName(BatchTokenHolder tokens, String name) {
        Token token = tokens.byName(name);
        return token != null ? token.id() : -1;
    }

    private boolean primitiveHasProperty(PrimitiveRecord record, String propertyName) {
        int propertyKeyId = this.tokenIdByName(this.propertyKeyTokens, propertyName);
        return propertyKeyId != -1 && this.propertyTraverser.findPropertyRecordContaining(record, propertyKeyId, this.recordAccess.getPropertyRecords(), false) != (long)Record.NO_NEXT_PROPERTY.intValue();
    }

    private void rejectAutoUpgrade(Map<String, String> params) {
        if (Boolean.parseBoolean(params.get(GraphDatabaseSettings.allow_store_upgrade.name()))) {
            throw new IllegalArgumentException("Batch inserter is not allowed to do upgrade of a store, use " + EmbeddedGraphDatabase.class.getSimpleName() + " instead");
        }
    }

    @Override
    public long createNode(Map<String, Object> properties, Label ... labels) {
        return this.internalCreateNode(this.nodeStore.nextId(), properties, labels);
    }

    private long internalCreateNode(long nodeId, Map<String, Object> properties, Label ... labels) {
        NodeRecord nodeRecord = this.recordAccess.getNodeRecords().create(nodeId, null).forChangingData();
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
        nodeRecord.setNextProp(this.propertyCreator.createPropertyChain(nodeRecord, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        if (labels.length > 0) {
            this.setNodeLabels(nodeRecord, labels);
        }
        this.flushStrategy.flush();
        return nodeId;
    }

    private Iterator<PropertyBlock> propertiesIterator(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return IteratorUtil.emptyIterator();
        }
        return new IteratorWrapper<PropertyBlock, Map.Entry<String, Object>>(properties.entrySet().iterator()){

            @Override
            protected PropertyBlock underlyingObjectToObject(Map.Entry<String, Object> property) {
                return BatchInserterImpl.this.propertyCreator.encodePropertyValue(BatchInserterImpl.this.getOrCreatePropertyKeyId(property.getKey()), property.getValue());
            }
        };
    }

    private void setNodeLabels(NodeRecord nodeRecord, Label ... labels) {
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField(nodeRecord);
        this.nodeStore.updateDynamicLabelRecords(nodeLabels.put(this.getOrCreateLabelIds(labels), this.nodeStore, this.nodeStore.getDynamicLabelStore()));
        this.labelsTouched = true;
    }

    private long[] getOrCreateLabelIds(Label[] labels) {
        long[] ids = new long[labels.length];
        int cursor = 0;
        for (int i = 0; i < ids.length; ++i) {
            int labelId = this.getOrCreateLabelId(labels[i].name());
            if (this.arrayContains(ids, cursor, labelId)) continue;
            ids[cursor++] = labelId;
        }
        if (cursor < ids.length) {
            ids = Arrays.copyOf(ids, cursor);
        }
        return ids;
    }

    private boolean arrayContains(long[] ids, int cursor, int labelId) {
        for (int i = 0; i < cursor; ++i) {
            if (ids[i] != (long)labelId) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createNode(long id, Map<String, Object> properties, Label ... labels) {
        if (id < 0L || id > MAX_NODE_ID) {
            throw new IllegalArgumentException("id=" + id);
        }
        if (id == 0xFFFFFFFFL) {
            throw new IllegalArgumentException("id " + id + " is reserved for internal use");
        }
        if (this.nodeStore.loadLightNode(id) != null) {
            throw new IllegalArgumentException("id=" + id + " already in use");
        }
        long highId = this.nodeStore.getHighId();
        if (highId <= id) {
            this.nodeStore.setHighestPossibleIdInUse(id);
        }
        this.internalCreateNode(id, properties, labels);
    }

    @Override
    public void setNodeLabels(long node, Label ... labels) {
        NodeRecord record = this.getNodeRecord(node).forChangingData();
        this.setNodeLabels(record, labels);
        this.flushStrategy.flush();
    }

    @Override
    public Iterable<Label> getNodeLabels(final long node) {
        return new Iterable<Label>(){

            @Override
            public Iterator<Label> iterator() {
                NodeRecord record = (NodeRecord)BatchInserterImpl.this.getNodeRecord(node).forReadingData();
                long[] labels = NodeLabelsField.parseLabelsField(record).get(BatchInserterImpl.this.nodeStore);
                return PrimitiveLongCollections.map((FunctionFromPrimitiveLong)BatchInserterImpl.this.labelIdToLabelFunction, (PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])labels));
            }
        };
    }

    @Override
    public boolean nodeHasLabel(long node, Label label) {
        int labelId = this.tokenIdByName(this.labelTokens, label.name());
        return labelId != -1 && this.nodeHasLabel(node, labelId);
    }

    private boolean nodeHasLabel(long node, int labelId) {
        NodeRecord record = this.getNodeRecord(node).forReadingData();
        for (long label : NodeLabelsField.parseLabelsField(record).get(this.nodeStore)) {
            if (label != (long)labelId) continue;
            return true;
        }
        return false;
    }

    @Override
    public long createRelationship(long node1, long node2, RelationshipType type, Map<String, Object> properties) {
        long id = this.relationshipStore.nextId();
        int typeId = this.getOrCreateRelationshipTypeToken(type);
        this.relationshipCreator.relationshipCreate(id, typeId, node1, node2, this.recordAccess);
        if (properties != null && !properties.isEmpty()) {
            RelationshipRecord record = this.recordAccess.getRelRecords().getOrLoad(id, null).forChangingData();
            record.setNextProp(this.propertyCreator.createPropertyChain(record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        }
        this.flushStrategy.flush();
        return id;
    }

    @Override
    public void setNodeProperties(long node, Map<String, Object> properties) {
        NodeRecord record = this.getNodeRecord(node).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.propertyDeletor.deletePropertyChain(record, this.recordAccess.getPropertyRecords());
        }
        record.setNextProp(this.propertyCreator.createPropertyChain(record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        this.flushStrategy.flush();
    }

    @Override
    public void setRelationshipProperties(long rel, Map<String, Object> properties) {
        RelationshipRecord record = this.recordAccess.getRelRecords().getOrLoad(rel, null).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.propertyDeletor.deletePropertyChain(record, this.recordAccess.getPropertyRecords());
        }
        record.setNextProp(this.propertyCreator.createPropertyChain(record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        this.flushStrategy.flush();
    }

    @Override
    public boolean nodeExists(long nodeId) {
        this.flushStrategy.forceFlush();
        return this.nodeStore.loadLightNode(nodeId) != null;
    }

    @Override
    public Map<String, Object> getNodeProperties(long nodeId) {
        NodeRecord record = this.getNodeRecord(nodeId).forReadingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public Iterable<Long> getRelationshipIds(long nodeId) {
        this.flushStrategy.forceFlush();
        return new BatchRelationshipIterable<Long>(this.neoStores, nodeId){

            @Override
            protected Long nextFrom(long relId, int type, long startNode, long endNode) {
                return relId;
            }
        };
    }

    @Override
    public Iterable<BatchRelationship> getRelationships(long nodeId) {
        this.flushStrategy.forceFlush();
        return new BatchRelationshipIterable<BatchRelationship>(this.neoStores, nodeId){

            @Override
            protected BatchRelationship nextFrom(long relId, int type, long startNode, long endNode) {
                return new BatchRelationship(relId, startNode, endNode, (RelationshipType)((Object)BatchInserterImpl.this.relationshipTypeTokens.byId(type)));
            }
        };
    }

    @Override
    public BatchRelationship getRelationshipById(long relId) {
        RelationshipRecord record = this.getRelationshipRecord(relId).forReadingData();
        RelationshipType type = (RelationshipType)((Object)this.relationshipTypeTokens.byId(record.getType()));
        return new BatchRelationship(record.getId(), record.getFirstNode(), record.getSecondNode(), type);
    }

    @Override
    public Map<String, Object> getRelationshipProperties(long relId) {
        RelationshipRecord record = this.recordAccess.getRelRecords().getOrLoad(relId, null).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public void shutdown() {
        if (this.isShutdown) {
            throw new IllegalStateException("Batch inserter already has shutdown");
        }
        this.isShutdown = true;
        this.flushStrategy.forceFlush();
        try {
            this.repopulateAllIndexes();
        }
        catch (IOException | IndexCapacityExceededException | IndexEntryConflictException e) {
            throw new RuntimeException(e);
        }
        this.rebuildCounts();
        this.neoStores.close();
        try {
            this.storeLocker.release();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Could not release store lock", e);
        }
        this.msgLog.info(Thread.currentThread() + " Clean shutdown on BatchInserter(" + this + ")", new Object[]{true});
        this.life.shutdown();
    }

    public String toString() {
        return "EmbeddedBatchInserter[" + this.storeDir + "]";
    }

    private Map<String, Object> getPropertyChain(long nextProp) {
        final HashMap<String, Object> map = new HashMap<String, Object>();
        this.propertyTraverser.getPropertyChain(nextProp, this.recordAccess.getPropertyRecords(), new Listener<PropertyBlock>(){

            @Override
            public void receive(PropertyBlock propBlock) {
                String key = BatchInserterImpl.this.propertyKeyTokens.byId(propBlock.getKeyIndexId()).name();
                DefinedProperty propertyData = propBlock.newPropertyData(BatchInserterImpl.this.propertyStore);
                Object value = propertyData.value() != null ? propertyData.value() : propBlock.getType().getValue(propBlock, BatchInserterImpl.this.propertyStore);
                map.put(key, value);
            }
        });
        return map;
    }

    private int createNewPropertyKeyId(String stringKey) {
        int keyId = (int)this.propertyKeyTokenStore.nextId();
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(keyId);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> keyRecords = this.propertyKeyTokenStore.allocateNameRecords(PropertyStore.encodeString(stringKey));
        record.setNameId((int)IteratorUtil.first(keyRecords).getId());
        record.addNameRecords(keyRecords);
        this.propertyKeyTokenStore.updateRecord(record);
        this.propertyKeyTokens.addToken(new Token(stringKey, keyId));
        return keyId;
    }

    private int createNewLabelId(String stringKey) {
        int keyId = (int)this.labelTokenStore.nextId();
        LabelTokenRecord record = new LabelTokenRecord(keyId);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> keyRecords = this.labelTokenStore.allocateNameRecords(PropertyStore.encodeString(stringKey));
        record.setNameId((int)IteratorUtil.first(keyRecords).getId());
        record.addNameRecords(keyRecords);
        this.labelTokenStore.updateRecord(record);
        this.labelTokens.addToken(new Token(stringKey, keyId));
        return keyId;
    }

    private int createNewRelationshipType(String name) {
        int id = (int)this.relationshipTypeTokenStore.nextId();
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> nameRecords = this.relationshipTypeTokenStore.allocateNameRecords(PropertyStore.encodeString(name));
        record.setNameId((int)IteratorUtil.first(nameRecords).getId());
        record.addNameRecords(nameRecords);
        this.relationshipTypeTokenStore.updateRecord(record);
        this.relationshipTypeTokens.addToken(new RelationshipTypeToken(name, id));
        return id;
    }

    private RecordAccess.RecordProxy<Long, NodeRecord, Void> getNodeRecord(long id) {
        if (id < 0L || id >= this.nodeStore.getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.recordAccess.getNodeRecords().getOrLoad(id, null);
    }

    private RecordAccess.RecordProxy<Long, RelationshipRecord, Void> getRelationshipRecord(long id) {
        if (id < 0L || id >= this.relationshipStore.getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.recordAccess.getRelRecords().getOrLoad(id, null);
    }

    @Override
    public String getStoreDir() {
        return this.storeDir.getPath();
    }

    public IndexConfigStore getIndexStore() {
        return this.indexStore;
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    private void dumpConfiguration(Map<String, String> config, PrintStream out) {
        for (String key : config.keySet()) {
            String value = config.get(key);
            if (value == null) continue;
            out.println(key + "=" + value);
        }
    }

    static final class BatchedFlushStrategy
    implements FlushStrategy {
        private final DirectRecordAccessSet directRecordAccess;
        private final int batchSize;
        private int attempts;

        public BatchedFlushStrategy(DirectRecordAccessSet directRecordAccess, int batchSize) {
            this.directRecordAccess = directRecordAccess;
            this.batchSize = batchSize;
        }

        @Override
        public void flush() {
            ++this.attempts;
            if (this.attempts >= this.batchSize) {
                this.forceFlush();
            }
        }

        @Override
        public void forceFlush() {
            this.directRecordAccess.commit();
            this.attempts = 0;
        }
    }

    static interface FlushStrategy {
        public void flush();

        public void forceFlush();
    }

    private class BatchSchemaActions
    implements InternalSchemaActions {
        private BatchSchemaActions() {
        }

        @Override
        public IndexDefinition createIndexDefinition(Label label, String propertyKey) {
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(label.name());
            int propertyKeyId = BatchInserterImpl.this.getOrCreatePropertyKeyId(propertyKey);
            BatchInserterImpl.this.validateIndexCanBeCreated(labelId, propertyKeyId);
            BatchInserterImpl.this.createIndexRule(labelId, propertyKeyId);
            return new IndexDefinitionImpl(this, label, propertyKey, false);
        }

        @Override
        public void dropIndexDefinitions(Label label, String propertyKey) {
            throw this.unsupportedException();
        }

        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(Label label, String propertyKey) {
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(label.name());
            int propertyKeyId = BatchInserterImpl.this.getOrCreatePropertyKeyId(propertyKey);
            BatchInserterImpl.this.validateUniquenessConstraintCanBeCreated(labelId, propertyKeyId);
            BatchInserterImpl.this.createConstraintRule(new UniquenessConstraint(labelId, propertyKeyId));
            return new UniquenessConstraintDefinition(this, label, propertyKey);
        }

        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(Label label, String propertyKey) {
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(label.name());
            int propertyKeyId = BatchInserterImpl.this.getOrCreatePropertyKeyId(propertyKey);
            BatchInserterImpl.this.validateNodePropertyExistenceConstraintCanBeCreated(labelId, propertyKeyId);
            BatchInserterImpl.this.createConstraintRule(new NodePropertyExistenceConstraint(labelId, propertyKeyId));
            return new NodePropertyExistenceConstraintDefinition(this, label, propertyKey);
        }

        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(RelationshipType type, String propertyKey) throws CreateConstraintFailureException, AlreadyConstrainedException {
            int relationshipTypeId = BatchInserterImpl.this.getOrCreateRelationshipTypeId(type.name());
            int propertyKeyId = BatchInserterImpl.this.getOrCreatePropertyKeyId(propertyKey);
            BatchInserterImpl.this.validateRelationshipConstraintCanBeCreated(relationshipTypeId, propertyKeyId);
            BatchInserterImpl.this.createConstraintRule(new RelationshipPropertyExistenceConstraint(relationshipTypeId, propertyKeyId));
            return new RelationshipPropertyExistenceConstraintDefinition(this, type, propertyKey);
        }

        @Override
        public void dropPropertyUniquenessConstraint(Label label, String propertyKey) {
            throw this.unsupportedException();
        }

        @Override
        public void dropNodePropertyExistenceConstraint(Label label, String propertyKey) {
            throw this.unsupportedException();
        }

        @Override
        public void dropRelationshipPropertyExistenceConstraint(RelationshipType type, String propertyKey) {
            throw this.unsupportedException();
        }

        @Override
        public String getUserMessage(KernelException e) {
            throw this.unsupportedException();
        }

        @Override
        public void assertInUnterminatedTransaction() {
        }

        private UnsupportedOperationException unsupportedException() {
            return new UnsupportedOperationException("Batch inserter doesn't support this");
        }
    }

    private class InitialNodeLabelCreationVisitor
    implements Visitor<NodeLabelUpdate, IOException> {
        LabelScanWriter writer;

        private InitialNodeLabelCreationVisitor() {
            this.writer = BatchInserterImpl.this.labelScanStore.newWriter();
        }

        @Override
        public boolean visit(NodeLabelUpdate update) throws IOException {
            try {
                this.writer.write(update);
            }
            catch (IndexCapacityExceededException e) {
                throw new UnderlyingStorageException(e);
            }
            return true;
        }

        public void close() throws IOException {
            this.writer.close();
        }
    }
}

