/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.index.Reservation;

class AggregatedReservation
implements Reservation {
    private final Reservation[] aggregates;
    private int pointer;

    AggregatedReservation(int size) {
        this.aggregates = new Reservation[size];
    }

    void add(Reservation reservation) {
        if (this.pointer == this.aggregates.length) {
            throw new IndexOutOfBoundsException("Too many aggregates, size = " + this.aggregates.length);
        }
        if (this == reservation) {
            throw new IllegalArgumentException("Recursive aggregates not allowed");
        }
        this.aggregates[this.pointer++] = reservation;
    }

    @Override
    public void release() {
        Throwable firstError = null;
        for (Reservation aggregate : this.aggregates) {
            if (aggregate == null) continue;
            try {
                aggregate.release();
            }
            catch (Throwable t) {
                if (firstError != null) continue;
                firstError = t;
            }
        }
        if (firstError != null) {
            throw Exceptions.launderedException(firstError);
        }
    }
}

