/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.neo4j.helpers.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveFormat;
import org.neo4j.kernel.impl.store.kvstore.RotationMonitor;

abstract class RotationStrategy {
    protected final FileSystemAbstraction fs;
    protected final PageCache pages;
    private final ProgressiveFormat format;
    private final RotationMonitor monitor;

    RotationStrategy(FileSystemAbstraction fs, PageCache pages, ProgressiveFormat format, RotationMonitor monitor) {
        this.fs = fs;
        this.pages = pages;
        this.format = format;
        this.monitor = monitor;
    }

    protected abstract File initialFile();

    protected abstract Iterable<File> candidateFiles();

    protected abstract File nextFile(File var1);

    public final Pair<File, KeyValueStoreFile> open() throws IOException {
        KeyValueStoreFile result = null;
        File path = null;
        for (File candidatePath : this.candidateFiles()) {
            KeyValueStoreFile file;
            if (!this.fs.fileExists(candidatePath)) continue;
            try {
                file = this.format.openStore(this.fs, this.pages, candidatePath);
            }
            catch (Exception e) {
                this.monitor.failedToOpenStoreFile(candidatePath, e);
                continue;
            }
            if (result == null || this.format.compareHeaders(result.headers(), file.headers()) < 0) {
                if (result != null) {
                    result.close();
                }
                result = file;
                path = candidatePath;
                continue;
            }
            file.close();
        }
        return result == null ? null : Pair.of(path, result);
    }

    public final Pair<File, KeyValueStoreFile> create(DataProvider initialData, long version) throws IOException {
        File path = this.initialFile();
        return Pair.of(path, this.format.createStore(this.fs, this.pages, path, this.format.keySize(), this.format.valueSize(), this.format.initialHeaders(version), initialData));
    }

    public final Pair<File, KeyValueStoreFile> next(File file, Headers headers, DataProvider data) throws IOException {
        KeyValueStoreFile store;
        File path = this.nextFile(file);
        this.monitor.beforeRotation(file, path, headers);
        try {
            store = this.format.createStore(this.fs, this.pages, path, this.format.keySize(), this.format.valueSize(), headers, data);
        }
        catch (Exception e) {
            this.monitor.rotationFailed(file, path, headers, e);
            throw e;
        }
        this.monitor.rotationSucceeded(file, path, headers);
        return Pair.of(path, store);
    }

    final KeyValueStoreFile openStoreFile(File path) throws IOException {
        return this.format.openStore(this.fs, this.pages, path);
    }

    static class Incrementing
    extends RotationStrategy
    implements FilenameFilter {
        private static final Pattern SUFFIX = Pattern.compile("\\.[0-9]+");
        private final File base;

        public Incrementing(FileSystemAbstraction fs, PageCache pages, ProgressiveFormat format, RotationMonitor monitor, File base) {
            super(fs, pages, format, monitor);
            this.base = base;
        }

        @Override
        protected File initialFile() {
            return new File(this.base.getParent(), this.base.getName() + ".0");
        }

        @Override
        protected Iterable<File> candidateFiles() {
            return Arrays.asList(this.fs.listFiles(this.base.getParentFile(), (FilenameFilter)this));
        }

        @Override
        protected File nextFile(File previous) {
            int next;
            String name = previous.getName();
            int pos = name.lastIndexOf(46);
            try {
                int number = Integer.parseInt(name.substring(pos + 1));
                if (!this.base.getParent().equals(previous.getParent()) || !this.base.getName().equals(name.substring(0, pos))) {
                    throw new IllegalStateException("Invalid path: " + previous);
                }
                next = number + 1;
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Invalid path: " + previous, e);
            }
            return new File(this.base.getParent(), this.base.getName() + "." + next);
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.base.getName()) && SUFFIX.matcher(name.substring(this.base.getName().length())).matches();
        }
    }

    static class LeftRight
    extends RotationStrategy {
        private final File left;
        private final File right;

        LeftRight(FileSystemAbstraction fs, PageCache pages, ProgressiveFormat format, RotationMonitor monitor, File left, File right) {
            super(fs, pages, format, monitor);
            this.left = left;
            this.right = right;
        }

        @Override
        protected File initialFile() {
            return this.left;
        }

        @Override
        protected Iterable<File> candidateFiles() {
            return Arrays.asList(this.left, this.right);
        }

        @Override
        protected File nextFile(File previous) {
            if (this.left.equals(previous)) {
                return this.right;
            }
            if (this.right.equals(previous)) {
                return this.left;
            }
            throw new IllegalStateException("Invalid path: " + previous);
        }
    }
}

