/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;

@Deprecated
public class TopLevelTransaction
implements Transaction {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final ThreadToStatementContextBridge stmtProvider;
    private boolean successCalled;
    private boolean failureCalled;
    private final KernelTransaction transaction;

    public TopLevelTransaction(KernelTransaction transaction, ThreadToStatementContextBridge stmtProvider) {
        this.transaction = transaction;
        this.stmtProvider = stmtProvider;
        this.transaction.registerCloseListener(success -> stmtProvider.unbindTransactionFromCurrentThread());
    }

    @Override
    public void failure() {
        this.failureCalled = true;
        this.transaction.failure();
    }

    @Override
    public void success() {
        this.successCalled = true;
        this.transaction.success();
    }

    @Override
    public final void finish() {
        this.close();
    }

    @Override
    public final void terminate() {
        this.transaction.markForTermination();
    }

    @Override
    public void close() {
        try {
            if (this.transaction.isOpen()) {
                this.transaction.close();
            }
        }
        catch (TransientFailureException e) {
            throw e;
        }
        catch (ConstraintViolationTransactionFailureException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (Exception e) {
            String userMessage;
            String string = userMessage = this.successCalled ? "Transaction was marked as successful, but unable to commit transaction so rolled back." : "Unable to rollback transaction";
            if (e instanceof KernelException && ((KernelException)e).status().code().classification() == Status.Classification.TransientError) {
                throw new TransientTransactionFailureException(userMessage, e);
            }
            throw new TransactionFailureException(userMessage, e);
        }
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer entity) {
        return locker.exclusiveLock(this.stmtProvider, entity);
    }

    @Override
    public Lock acquireReadLock(PropertyContainer entity) {
        return locker.sharedLock(this.stmtProvider, entity);
    }

    @Deprecated
    public KernelTransaction getTransaction() {
        return this.transaction;
    }

    boolean failureCalled() {
        return this.failureCalled;
    }
}

