/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.constraints;

import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;

public class RelationshipPropertyExistenceConstraint
extends RelationshipPropertyConstraint {
    public RelationshipPropertyExistenceConstraint(int relTypeId, int propertyKeyId) {
        super(relTypeId, propertyKeyId);
    }

    @Override
    public void added(PropertyConstraint.ChangeVisitor visitor) throws CreateConstraintFailureException {
        visitor.visitAddedRelationshipPropertyExistenceConstraint(this);
    }

    @Override
    public void removed(PropertyConstraint.ChangeVisitor visitor) {
        visitor.visitRemovedRelationshipPropertyExistenceConstraint(this);
    }

    @Override
    public ConstraintType type() {
        return ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE;
    }

    @Override
    public ConstraintDefinition asConstraintDefinition(InternalSchemaActions schemaActions, ReadOperations readOps) {
        StatementTokenNameLookup lookup = new StatementTokenNameLookup(readOps);
        return new RelationshipPropertyExistenceConstraintDefinition(schemaActions, RelationshipType.withName(lookup.relationshipTypeGetName(this.relationshipTypeId)), lookup.propertyKeyGetName(this.propertyKeyId));
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        String typeName = tokenNameLookup.relationshipTypeGetName(this.relationshipTypeId);
        String boundIdentifier = typeName.toLowerCase();
        return String.format("CONSTRAINT ON ()-[ %s:%s ]-() ASSERT exists(%s.%s)", boundIdentifier, typeName, boundIdentifier, tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }

    @Override
    public String toString() {
        return String.format("CONSTRAINT ON ()-[ n:relationshipType[%s] ]-() ASSERT exists(n.property[%s])", this.relationshipTypeId, this.propertyKeyId);
    }
}

