/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.constraints;

import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.UniquenessConstraintDefinition;

public class UniquenessConstraint
extends NodePropertyConstraint {
    public UniquenessConstraint(int labelId, int propertyKeyId) {
        super(labelId, propertyKeyId);
    }

    @Override
    public void added(PropertyConstraint.ChangeVisitor visitor) {
        visitor.visitAddedUniquePropertyConstraint(this);
    }

    @Override
    public void removed(PropertyConstraint.ChangeVisitor visitor) {
        visitor.visitRemovedUniquePropertyConstraint(this);
    }

    @Override
    public ConstraintDefinition asConstraintDefinition(InternalSchemaActions schemaActions, ReadOperations readOps) {
        StatementTokenNameLookup lookup = new StatementTokenNameLookup(readOps);
        return new UniquenessConstraintDefinition(schemaActions, Label.label(lookup.labelGetName(this.labelId)), lookup.propertyKeyGetName(this.propertyKeyId));
    }

    @Override
    public ConstraintType type() {
        return ConstraintType.UNIQUENESS;
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        String labelName = tokenNameLookup.labelGetName(this.labelId);
        String boundIdentifier = labelName.toLowerCase();
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT %s.%s IS UNIQUE", boundIdentifier, labelName, boundIdentifier, tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }

    @Override
    public String toString() {
        return String.format("CONSTRAINT ON ( n:label[%s] ) ASSERT n.property[%s] IS UNIQUE", this.labelId, this.propertyKeyId);
    }
}

