/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.cursor;

import java.util.Arrays;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.cursor.DegreeItem;
import org.neo4j.kernel.api.cursor.EntityItem;
import org.neo4j.kernel.api.cursor.LabelItem;
import org.neo4j.kernel.api.cursor.RelationshipItem;
import org.neo4j.kernel.impl.api.store.CursorRelationshipIterator;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.Cursors;

public interface NodeItem
extends EntityItem {
    public static final ToIntFunction<LabelItem> GET_LABEL = IntSupplier::getAsInt;
    public static final ToIntFunction<IntSupplier> GET_RELATIONSHIP_TYPE = IntSupplier::getAsInt;

    public Cursor<LabelItem> labels();

    public Cursor<LabelItem> label(int var1);

    public Cursor<RelationshipItem> relationships(Direction var1, int ... var2);

    public Cursor<RelationshipItem> relationships(Direction var1);

    public Cursor<IntSupplier> relationshipTypes();

    public int degree(Direction var1);

    public int degree(Direction var1, int var2);

    public boolean isDense();

    public Cursor<DegreeItem> degrees();

    public boolean hasLabel(int var1);

    public PrimitiveIntIterator getLabels();

    public RelationshipIterator getRelationships(Direction var1, int[] var2);

    public RelationshipIterator getRelationships(Direction var1);

    public PrimitiveIntIterator getRelationshipTypes();

    public static abstract class NodeItemHelper
    extends EntityItem.EntityItemHelper
    implements NodeItem {
        @Override
        public boolean hasLabel(int labelId) {
            try (Cursor<LabelItem> labelCursor = this.label(labelId);){
                boolean bl = labelCursor.next();
                return bl;
            }
        }

        @Override
        public PrimitiveIntIterator getLabels() {
            return Cursors.intIterator(this.labels(), GET_LABEL);
        }

        @Override
        public RelationshipIterator getRelationships(Direction direction, int[] relTypes) {
            relTypes = NodeItemHelper.deduplicate(relTypes);
            return new CursorRelationshipIterator(this.relationships(direction, relTypes));
        }

        @Override
        public RelationshipIterator getRelationships(Direction direction) {
            return new CursorRelationshipIterator(this.relationships(direction));
        }

        @Override
        public PrimitiveIntIterator getRelationshipTypes() {
            return Cursors.intIterator(this.relationshipTypes(), GET_RELATIONSHIP_TYPE);
        }

        private static int[] deduplicate(int[] types) {
            int unique = 0;
            for (int i = 0; i < types.length; ++i) {
                int type = types[i];
                for (int j = 0; j < unique; ++j) {
                    if (type != types[j]) continue;
                    type = -1;
                    break;
                }
                if (type == -1) continue;
                types[unique++] = types[i];
            }
            if (unique < types.length) {
                types = Arrays.copyOf(types, unique);
            }
            return types;
        }
    }
}

