/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.txstate;

import java.util.Objects;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.txstate.ReadableTxState;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.util.diffsets.DiffSetsVisitor;

public abstract class RelationshipChangeVisitorAdapter
implements DiffSetsVisitor<Long> {
    private final DetailVisitor added;
    private final DetailVisitor removed;

    public RelationshipChangeVisitorAdapter(ReadableTxState txState) {
        this.added = this.added(Objects.requireNonNull(txState, "ReadableTxState"));
        this.removed = null;
    }

    protected void visitAddedRelationship(long relationshipId) throws ConstraintValidationKernelException {
        if (this.added != null) {
            this.added.visit(relationshipId);
        }
    }

    protected void visitRemovedRelationship(long relationshipId) throws ConstraintValidationKernelException {
        if (this.removed != null) {
            this.removed.visit(relationshipId);
        }
    }

    protected void visitAddedRelationship(long relationshipId, int type, long startNode, long endNode) throws ConstraintValidationKernelException {
    }

    protected void visitRemovedRelationship(long relationshipId, int type, long startNode, long endNode) {
    }

    @Override
    public final void visitAdded(Long relationshipId) throws ConstraintValidationKernelException {
        this.visitAddedRelationship(relationshipId);
    }

    @Override
    public final void visitRemoved(Long relationshipId) throws ConstraintValidationKernelException {
        this.visitRemovedRelationship(relationshipId);
    }

    DetailVisitor added(final ReadableTxState txState) {
        return new DetailVisitor(){

            @Override
            void visit(long relationshipId) throws ConstraintValidationKernelException {
                if (!txState.relationshipVisit(relationshipId, this)) {
                    throw new IllegalStateException("No RelationshipState for added relationship!");
                }
            }

            @Override
            public void visit(long relId, int type, long startNode, long endNode) throws ConstraintValidationKernelException {
                RelationshipChangeVisitorAdapter.this.visitAddedRelationship(relId, type, startNode, endNode);
            }
        };
    }

    DetailVisitor removed(final StoreReadLayer store) {
        return new DetailVisitor(){

            @Override
            void visit(long relationshipId) throws ConstraintValidationKernelException {
                try {
                    store.relationshipVisit(relationshipId, this);
                }
                catch (EntityNotFoundException e) {
                    throw new IllegalStateException("No RelationshipState for removed relationship!", e);
                }
            }

            @Override
            public void visit(long relId, int type, long startNode, long endNode) {
                RelationshipChangeVisitorAdapter.this.visitRemovedRelationship(relId, type, startNode, endNode);
            }
        };
    }

    private static abstract class DetailVisitor
    implements RelationshipVisitor<ConstraintValidationKernelException> {
        private DetailVisitor() {
        }

        abstract void visit(long var1) throws ConstraintValidationKernelException;

        @Override
        public abstract void visit(long var1, int var3, long var4, long var6) throws ConstraintValidationKernelException;
    }
}

