/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.function.Predicate;
import org.neo4j.kernel.configuration.ConfigurationChange;
import org.neo4j.kernel.configuration.ConfigurationChangeListener;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class RestartOnChange
implements ConfigurationChangeListener {
    private final Predicate<String> restartSpecification;
    private final Lifecycle life;

    public RestartOnChange(String configurationNamePrefix, Lifecycle life) {
        this((String item) -> item.startsWith(configurationNamePrefix), life);
    }

    public RestartOnChange(Predicate<String> restartSpecification, Lifecycle life) {
        this.restartSpecification = restartSpecification;
        this.life = life;
    }

    @Override
    public void notifyConfigurationChanges(Iterable<ConfigurationChange> change) {
        boolean restart = false;
        for (ConfigurationChange configurationChange : change) {
            restart |= this.restartSpecification.test(configurationChange.getName());
        }
        if (restart) {
            try {
                this.life.stop();
                this.life.start();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

