/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.neo4j.function.Functions;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;

public class Settings {
    private static final String MATCHES_PATTERN_MESSAGE = "matches the pattern `%s`";
    public static final String MANDATORY = new String("mandatory");
    public static final String NO_DEFAULT = null;
    public static final String EMPTY = "";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String DEFAULT = "default";
    public static final String SEPARATOR = ",";
    public static final String DURATION_FORMAT = "\\d+(ms|s|m)";
    public static final String SIZE_FORMAT = "\\d+[kmgKMG]?";
    private static final String DURATION_UNITS = "\\d+(ms|s|m)".substring("\\d+(ms|s|m)".indexOf(40) + 1, "\\d+(ms|s|m)".indexOf(41)).replace("|", ", ");
    private static final String SIZE_UNITS = Arrays.toString("\\d+[kmgKMG]?".substring("\\d+[kmgKMG]?".indexOf(91) + 1, "\\d+[kmgKMG]?".indexOf(93)).toCharArray()).replace("[", "").replace("]", "");
    public static final String ANY = ".+";
    public static final Function<String, Integer> INTEGER = new Function<String, Integer>(){

        @Override
        public Integer apply(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a valid integer value");
            }
        }

        public String toString() {
            return "an integer";
        }
    };
    public static final Function<String, Long> LONG = new Function<String, Long>(){

        @Override
        public Long apply(String value) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a valid long value");
            }
        }

        public String toString() {
            return "a long";
        }
    };
    public static final Function<String, Boolean> BOOLEAN = new Function<String, Boolean>(){

        @Override
        public Boolean apply(String value) {
            if (value.equalsIgnoreCase(Settings.TRUE)) {
                return true;
            }
            if (value.equalsIgnoreCase(Settings.FALSE)) {
                return false;
            }
            throw new IllegalArgumentException("must be 'true' or 'false'");
        }

        public String toString() {
            return "a boolean";
        }
    };
    public static final Function<String, Float> FLOAT = new Function<String, Float>(){

        @Override
        public Float apply(String value) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a valid float value");
            }
        }

        public String toString() {
            return "a float";
        }
    };
    public static final Function<String, Double> DOUBLE = new Function<String, Double>(){

        @Override
        public Double apply(String value) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a valid double value");
            }
        }

        public String toString() {
            return "a double";
        }
    };
    public static final Function<String, String> STRING = new Function<String, String>(){

        @Override
        public String apply(String value) {
            return value.trim();
        }

        public String toString() {
            return "a string";
        }
    };
    public static final Function<String, List<String>> STRING_LIST = new Function<String, List<String>>(){

        @Override
        public List<String> apply(String value) {
            String[] list = value.split(Settings.SEPARATOR);
            ArrayList<String> result = new ArrayList<String>();
            for (String item : list) {
                if ((item = item.trim()).equals(Settings.EMPTY)) continue;
                result.add(item);
            }
            return result;
        }

        public String toString() {
            return "a comma-seperated string";
        }
    };
    public static final Function<String, HostnamePort> HOSTNAME_PORT = new Function<String, HostnamePort>(){

        @Override
        public HostnamePort apply(String value) {
            return new HostnamePort(value);
        }

        public String toString() {
            return "a hostname and port";
        }
    };
    public static final Function<String, Long> DURATION = new Function<String, Long>(){

        @Override
        public Long apply(String value) {
            return TimeUtil.parseTimeMillis.apply(value);
        }

        public String toString() {
            return "a duration (valid units are `" + DURATION_UNITS.replace(", ", "`, `") + "`)";
        }
    };
    public static final Function<String, Long> BYTES = new Function<String, Long>(){

        @Override
        public Long apply(String value) {
            try {
                String mem = value.toLowerCase();
                long multiplier = 1L;
                if (mem.endsWith("k")) {
                    multiplier = 1024L;
                    mem = mem.substring(0, mem.length() - 1);
                } else if (mem.endsWith("m")) {
                    multiplier = 0x100000L;
                    mem = mem.substring(0, mem.length() - 1);
                } else if (mem.endsWith("g")) {
                    multiplier = 0x40000000L;
                    mem = mem.substring(0, mem.length() - 1);
                }
                long bytes = Long.parseLong(mem.trim()) * multiplier;
                if (bytes < 0L) {
                    throw new IllegalArgumentException(value + " is not a valid number of bytes. Must be positive or zero.");
                }
                return bytes;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("%s is not a valid size, must be e.g. 10, 5K, 1M, 11G", value));
            }
        }

        public String toString() {
            return "a byte size (valid multipliers are `" + SIZE_UNITS.replace(", ", "`, `") + "`)";
        }
    };
    public static final Function<String, URI> URI = new Function<String, URI>(){

        @Override
        public URI apply(String value) {
            try {
                return new URI(value);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("not a valid URI");
            }
        }

        public String toString() {
            return "a URI";
        }
    };
    public static final Function<String, URI> NORMALIZED_RELATIVE_URI = new Function<String, URI>(){

        @Override
        public URI apply(String value) {
            try {
                String normalizedUri = new URI(value).normalize().getPath();
                if (normalizedUri.endsWith("/")) {
                    normalizedUri = normalizedUri.substring(0, normalizedUri.length() - 1);
                }
                return new URI(normalizedUri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("not a valid URI");
            }
        }

        public String toString() {
            return "a URI";
        }
    };
    public static final Function<String, File> PATH = new Function<String, File>(){

        @Override
        public File apply(String setting) {
            setting = FileUtils.fixSeparatorsInPath((String)setting);
            return new File(setting);
        }

        public String toString() {
            return "a path";
        }
    };
    public static final Function<String, Long> LONG_WITH_OPTIONAL_UNIT = Config::parseLongWithUnit;
    public static final BiFunction<Integer, Function<String, String>, Integer> port = Settings.illegalValueMessage("must be a valid port number", Settings.range(0, 65535));
    public static BiFunction<String, Function<String, String>, String> toLowerCase = (value, settings) -> value.toLowerCase();
    public static BiFunction<URI, Function<String, String>, URI> normalize = (value, settings) -> {
        String resultStr = value.normalize().toString();
        if (resultStr.endsWith("/")) {
            value = java.net.URI.create(resultStr.substring(0, resultStr.length() - 1));
        }
        return value;
    };
    public static BiFunction<File, Function<String, String>, File> isFile = (path, settings) -> {
        if (path.exists() && !path.isFile()) {
            throw new IllegalArgumentException(String.format("%s must point to a file, not a directory", path.toString()));
        }
        return path;
    };
    public static BiFunction<File, Function<String, String>, File> isDirectory = (path, settings) -> {
        if (path.exists() && !path.isDirectory()) {
            throw new IllegalArgumentException(String.format("%s must point to a file, not a directory", path.toString()));
        }
        return path;
    };

    public static <T> Setting<T> setting(String name, Function<String, T> parser, String defaultValue) {
        return Settings.setting(name, parser, defaultValue, (Setting)null, new BiFunction[0]);
    }

    public static <T> Setting<T> setting(String name, Function<String, T> parser, String defaultValue, BiFunction<T, Function<String, String>, T> ... valueConverters) {
        return Settings.setting(name, parser, defaultValue, null, valueConverters);
    }

    public static <T> Setting<T> setting(String name, Function<String, T> parser, Setting<T> inheritedSetting) {
        return Settings.setting(name, parser, null, inheritedSetting, new BiFunction[0]);
    }

    public static <T> Setting<T> setting(String name, Function<String, T> parser, String defaultValue, Setting<T> inheritedSetting, BiFunction<T, Function<String, String>, T> ... valueConverters) {
        Function<Function<String, String>, String> valueLookup = Settings.named(name);
        Function<Function<String, String>, String> defaultLookup = defaultValue != null ? (defaultValue == MANDATORY ? Settings.mandatory(valueLookup) : Settings.withDefault(defaultValue, valueLookup)) : Functions.nullFunction();
        if (inheritedSetting != null) {
            valueLookup = Settings.inheritedValue(valueLookup, inheritedSetting);
            defaultLookup = Settings.inheritedDefault(defaultLookup, inheritedSetting);
        }
        return new DefaultSetting<T>(name, parser, valueLookup, defaultLookup, valueConverters);
    }

    private static <T> Function<Function<String, String>, String> inheritedValue(final Function<Function<String, String>, String> lookup, final Setting<T> inheritedSetting) {
        return new Function<Function<String, String>, String>(){

            @Override
            public String apply(Function<String, String> settings) {
                String value = (String)lookup.apply(settings);
                if (value == null) {
                    value = ((SettingHelper)inheritedSetting).lookup(settings);
                }
                return value;
            }
        };
    }

    private static <T> Function<Function<String, String>, String> inheritedDefault(Function<Function<String, String>, String> lookup, Setting<T> inheritedSetting) {
        return settings -> {
            String value = (String)lookup.apply((Function<String, String>)settings);
            if (value == null) {
                value = ((SettingHelper)inheritedSetting).defaultLookup((Function<String, String>)settings);
            }
            return value;
        };
    }

    public static <T extends Enum> Function<String, T> options(Class<T> enumClass) {
        return Settings.options(EnumSet.allOf(enumClass));
    }

    public static <T> Function<String, T> options(T ... optionValues) {
        return Settings.options(Iterables.iterable(optionValues));
    }

    public static <T> Function<String, T> options(final Iterable<T> optionValues) {
        return new Function<String, T>(){

            @Override
            public T apply(String value) {
                for (Object optionValue : optionValues) {
                    if (!optionValue.toString().equals(value)) continue;
                    return optionValue;
                }
                throw new IllegalArgumentException("must be one of " + Iterables.toList(optionValues).toString());
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("one of `");
                String comma = Settings.EMPTY;
                for (Object optionValue : optionValues) {
                    builder.append(comma).append(optionValue.toString());
                    comma = "`, `";
                }
                builder.append("`");
                return builder.toString();
            }
        };
    }

    public static <T> Function<String, List<T>> list(final String separator, final Function<String, T> itemParser) {
        return new Function<String, List<T>>(){

            @Override
            public List<T> apply(String value) {
                ArrayList list = new ArrayList();
                if (value.length() > 0) {
                    String[] parts;
                    for (String part : parts = value.split(separator)) {
                        list.add(itemParser.apply(part));
                    }
                }
                return list;
            }

            public String toString() {
                return "a list separated by \"" + separator + "\" where items are " + itemParser.toString();
            }
        };
    }

    public static BiFunction<String, Function<String, String>, String> matches(final String regex) {
        final Pattern pattern = Pattern.compile(regex);
        return new BiFunction<String, Function<String, String>, String>(){

            @Override
            public String apply(String value, Function<String, String> settings) {
                if (!pattern.matcher(value).matches()) {
                    throw new IllegalArgumentException("value does not match expression:" + regex);
                }
                return value;
            }

            public String toString() {
                return String.format(Settings.MATCHES_PATTERN_MESSAGE, regex);
            }
        };
    }

    public static <T extends Comparable<T>> BiFunction<T, Function<String, String>, T> min(final T min) {
        return new BiFunction<T, Function<String, String>, T>(){

            @Override
            public T apply(T value, Function<String, String> settings) {
                if (value != null && value.compareTo((Comparable)min) < 0) {
                    throw new IllegalArgumentException(String.format("minimum allowed value is: %s", min));
                }
                return value;
            }

            public String toString() {
                return "is minimum `" + min + "`";
            }
        };
    }

    public static <T extends Comparable<T>> BiFunction<T, Function<String, String>, T> max(final T max) {
        return new BiFunction<T, Function<String, String>, T>(){

            @Override
            public T apply(T value, Function<String, String> settings) {
                if (value != null && value.compareTo((Comparable)max) > 0) {
                    throw new IllegalArgumentException(String.format("maximum allowed value is: %s", max));
                }
                return value;
            }

            public String toString() {
                return "is maximum `" + max + "`";
            }
        };
    }

    public static <T extends Comparable<T>> BiFunction<T, Function<String, String>, T> range(final T min, final T max) {
        return new BiFunction<T, Function<String, String>, T>(){

            @Override
            public T apply(T from1, Function<String, String> from2) {
                return Settings.min(min).apply(Settings.max(max).apply((Comparable)from1, from2), from2);
            }

            public String toString() {
                return String.format("is in the range `%s` to `%s`", min, max);
            }
        };
    }

    public static <T> BiFunction<T, Function<String, String>, T> illegalValueMessage(final String message, final BiFunction<T, Function<String, String>, T> valueFunction) {
        return new BiFunction<T, Function<String, String>, T>(){

            @Override
            public T apply(T from1, Function<String, String> from2) {
                try {
                    return valueFunction.apply(from1, from2);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(message);
                }
            }

            public String toString() {
                String description = message;
                if (valueFunction != null && !String.format(Settings.MATCHES_PATTERN_MESSAGE, Settings.ANY).equals(valueFunction.toString())) {
                    description = description + " (" + valueFunction.toString() + ")";
                }
                return description;
            }
        };
    }

    public static BiFunction<File, Function<String, String>, File> basePath(final Setting<File> baseSetting) {
        return new BiFunction<File, Function<String, String>, File>(){

            @Override
            public File apply(File path, Function<String, String> settings) {
                File parent = (File)baseSetting.apply(settings);
                return path.isAbsolute() ? path : new File(parent, path.getPath());
            }

            public String toString() {
                return "is relative to " + baseSetting.name();
            }
        };
    }

    private static Function<Function<String, String>, String> named(String name) {
        return settings -> (String)settings.apply(name);
    }

    private static Function<Function<String, String>, String> withDefault(String defaultValue, Function<Function<String, String>, String> lookup) {
        return settings -> {
            String value = (String)lookup.apply((Function<String, String>)settings);
            if (value == null) {
                return defaultValue;
            }
            return value;
        };
    }

    private static Function<Function<String, String>, String> mandatory(Function<Function<String, String>, String> lookup) {
        return settings -> {
            String value = (String)lookup.apply((Function<String, String>)settings);
            if (value == null) {
                throw new IllegalArgumentException("mandatory setting is missing");
            }
            return value;
        };
    }

    private Settings() {
    }

    public static class DefaultSetting<T>
    implements SettingHelper<T> {
        private final String name;
        private final Function<String, T> parser;
        private final Function<Function<String, String>, String> valueLookup;
        private final Function<Function<String, String>, String> defaultLookup;
        private BiFunction<T, Function<String, String>, T>[] valueConverters;

        public DefaultSetting(String name, Function<String, T> parser, Function<Function<String, String>, String> valueLookup, Function<Function<String, String>, String> defaultLookup, BiFunction<T, Function<String, String>, T> ... valueConverters) {
            this.name = name;
            this.parser = parser;
            this.valueLookup = valueLookup;
            this.defaultLookup = defaultLookup;
            this.valueConverters = valueConverters;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultLookup(Functions.nullFunction());
        }

        @Override
        public String lookup(Function<String, String> settings) {
            return this.valueLookup.apply(settings);
        }

        @Override
        public String defaultLookup(Function<String, String> settings) {
            return this.defaultLookup.apply(settings);
        }

        @Override
        public T apply(Function<String, String> settings) {
            T result;
            String value = this.lookup(settings);
            if (value == null) {
                try {
                    value = this.defaultLookup(settings);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Missing mandatory setting '%s'", this.name()));
                }
            }
            if (value == null) {
                return null;
            }
            try {
                result = this.parser.apply(value);
                for (BiFunction<T, Function<String, String>, T> valueConverter : this.valueConverters) {
                    result = valueConverter.apply(result, settings);
                }
            }
            catch (IllegalArgumentException e) {
                throw new InvalidSettingException(this.name(), value, e.getMessage());
            }
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name).append(" is ").append(this.parser.toString());
            if (this.valueConverters.length > 0) {
                builder.append(" which ");
                for (int i = 0; i < this.valueConverters.length; ++i) {
                    BiFunction<T, Function<String, String>, T> valueConverter = this.valueConverters[i];
                    if (i > 0) {
                        builder.append(", and ");
                    }
                    builder.append(valueConverter);
                }
            }
            return builder.toString();
        }
    }

    private static interface SettingHelper<T>
    extends Setting<T> {
        public String lookup(Function<String, String> var1);

        public String defaultLookup(Function<String, String> var1);
    }
}

