/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.Optional;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsStoreTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.store.counts.CountsTracker;

public class CountsStoreBatchTransactionApplier
implements BatchTransactionApplier {
    private final CountsTracker countsTracker;
    private CountsAccessor.Updater countsUpdater;
    private final TransactionApplicationMode mode;

    public CountsStoreBatchTransactionApplier(CountsTracker countsTracker, TransactionApplicationMode mode) {
        this.countsTracker = countsTracker;
        this.mode = mode;
    }

    @Override
    public TransactionApplier startTx(TransactionToApply transaction) throws IOException {
        Optional<CountsAccessor.Updater> result = this.countsTracker.apply(transaction.transactionId());
        if (result.isPresent()) {
            this.countsUpdater = result.get();
        }
        assert (this.countsUpdater != null || this.mode == TransactionApplicationMode.RECOVERY);
        return new CountsStoreTransactionApplier(this.mode, this.countsUpdater);
    }

    @Override
    public TransactionApplier startTx(TransactionToApply transaction, LockGroup lockGroup) throws IOException {
        return this.startTx(transaction);
    }

    @Override
    public void close() throws Exception {
    }
}

