/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.LegacyIndexTransactionStateImpl;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.storageengine.StorageEngine;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.tracing.Tracers;

public class KernelTransactions
extends LifecycleAdapter
implements Factory<KernelTransaction> {
    private final Locks locks;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final StatementOperationParts statementOperations;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
    private final TransactionCommitProcess transactionCommitProcess;
    private final IndexConfigStore indexConfigStore;
    private final LegacyIndexProviderLookup legacyIndexProviderLookup;
    private final TransactionHooks hooks;
    private final TransactionMonitor transactionMonitor;
    private final LifeSupport dataSourceLife;
    private final Tracers tracers;
    private final StorageEngine storageEngine;
    private final Set<KernelTransaction> allTransactions = Collections.newSetFromMap(new ConcurrentHashMap());

    public KernelTransactions(Locks locks, ConstraintIndexCreator constraintIndexCreator, StatementOperationParts statementOperations, SchemaWriteGuard schemaWriteGuard, TransactionHeaderInformationFactory txHeaderFactory, TransactionCommitProcess transactionCommitProcess, IndexConfigStore indexConfigStore, LegacyIndexProviderLookup legacyIndexProviderLookup, TransactionHooks hooks, TransactionMonitor transactionMonitor, LifeSupport dataSourceLife, Tracers tracers, StorageEngine storageEngine) {
        this.locks = locks;
        this.constraintIndexCreator = constraintIndexCreator;
        this.statementOperations = statementOperations;
        this.schemaWriteGuard = schemaWriteGuard;
        this.transactionHeaderInformationFactory = txHeaderFactory;
        this.transactionCommitProcess = transactionCommitProcess;
        this.indexConfigStore = indexConfigStore;
        this.legacyIndexProviderLookup = legacyIndexProviderLookup;
        this.hooks = hooks;
        this.transactionMonitor = transactionMonitor;
        this.dataSourceLife = dataSourceLife;
        this.tracers = tracers;
        this.storageEngine = storageEngine;
    }

    public KernelTransaction newInstance() {
        this.assertDatabaseIsRunning();
        Locks.Client locksClient = this.locks.newClient();
        LegacyIndexTransactionStateImpl legacyIndexTransactionState = new LegacyIndexTransactionStateImpl(this.indexConfigStore, this.legacyIndexProviderLookup);
        long lastTransactionIdWhenStarted = this.storageEngine.metaDataStore().getLastCommittedTransactionId();
        KernelTransactionImplementation tx = new KernelTransactionImplementation(this.statementOperations, this.schemaWriteGuard, locksClient, this.hooks, this.constraintIndexCreator, this.transactionHeaderInformationFactory, this.transactionCommitProcess, this.transactionMonitor, legacyIndexTransactionState, this, Clock.SYSTEM_CLOCK, this.tracers.transactionTracer, this.storageEngine, lastTransactionIdWhenStarted);
        this.allTransactions.add(tx);
        return tx;
    }

    public void transactionClosed(KernelTransaction tx) {
        boolean removed = this.allTransactions.remove(tx);
        if (!removed) {
            throw new IllegalStateException("Transaction: " + tx + " is not present in the " + "set of known active transactions: " + this.allTransactions);
        }
    }

    public Set<KernelTransaction> activeTransactions() {
        return Collections.unmodifiableSet(new HashSet<KernelTransaction>(this.allTransactions));
    }

    public void disposeAll() {
        this.allTransactions.forEach(KernelTransaction::markForTermination);
    }

    @Override
    public void shutdown() throws Throwable {
        this.disposeAll();
    }

    private void assertDatabaseIsRunning() {
        if (!this.dataSourceLife.isRunning()) {
            throw new DatabaseShutdownException();
        }
    }
}

