/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.api.CommandVisitor;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.util.IdOrderingQueue;

public class LegacyIndexTransactionApplier
extends TransactionApplier.Adapter {
    private Map<String, TransactionApplier> applierByNodeIndex = Collections.emptyMap();
    private Map<String, TransactionApplier> applierByRelationshipIndex = Collections.emptyMap();
    Map<String, TransactionApplier> applierByProvider = Collections.emptyMap();
    private final LegacyIndexApplierLookup applierLookup;
    private final IndexConfigStore indexConfigStore;
    private final TransactionApplicationMode mode;
    private final IdOrderingQueue transactionOrdering;
    private IndexDefineCommand defineCommand;
    private long transactionId = -1L;

    public LegacyIndexTransactionApplier(LegacyIndexApplierLookup applierLookup, IndexConfigStore indexConfigStore, TransactionApplicationMode mode, IdOrderingQueue transactionOrdering) {
        this.applierLookup = applierLookup;
        this.indexConfigStore = indexConfigStore;
        this.mode = mode;
        this.transactionOrdering = transactionOrdering;
    }

    void setTransactionId(long txId) {
        this.transactionId = txId;
    }

    private TransactionApplier applier(IndexCommand command) throws IOException {
        String indexName = this.defineCommand.getIndexName(command.getIndexNameId());
        Map<String, TransactionApplier> applierByIndex = this.applierByIndexMap(command);
        TransactionApplier applier = applierByIndex.get(indexName);
        if (applier == null) {
            IndexEntityType entityType = IndexEntityType.byId(command.getEntityType());
            Map<String, String> config = this.indexConfigStore.get(entityType.entityClass(), indexName);
            if (config == null) {
                return TransactionApplier.EMPTY;
            }
            String providerName = config.get("provider");
            applier = this.applierByProvider.get(providerName);
            if (applier == null) {
                applier = this.applierLookup.newApplier(providerName, this.mode.needsIdempotencyChecks());
                applier.visitIndexDefineCommand(this.defineCommand);
                this.applierByProvider.put(providerName, applier);
            }
            applierByIndex.put(indexName, applier);
        }
        return applier;
    }

    private Map<String, TransactionApplier> applierByIndexMap(IndexCommand command) {
        if (command.getEntityType() == IndexEntityType.Node.id()) {
            if (this.applierByNodeIndex.isEmpty()) {
                this.applierByNodeIndex = new HashMap<String, TransactionApplier>();
                this.lazyCreateApplierByprovider();
            }
            return this.applierByNodeIndex;
        }
        if (command.getEntityType() == IndexEntityType.Relationship.id()) {
            if (this.applierByRelationshipIndex.isEmpty()) {
                this.applierByRelationshipIndex = new HashMap<String, TransactionApplier>();
                this.lazyCreateApplierByprovider();
            }
            return this.applierByRelationshipIndex;
        }
        throw new UnsupportedOperationException("Unknown entity type " + command.getEntityType());
    }

    private void lazyCreateApplierByprovider() {
        if (this.applierByProvider.isEmpty()) {
            this.applierByProvider = new HashMap<String, TransactionApplier>();
        }
    }

    @Override
    public void close() {
        this.notifyLegacyIndexOperationQueue();
    }

    private void notifyLegacyIndexOperationQueue() {
        if (this.transactionId != -1L) {
            this.transactionOrdering.removeChecked(this.transactionId);
            this.transactionId = -1L;
        }
    }

    @Override
    public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand command) throws IOException {
        return this.applier(command).visitIndexAddNodeCommand(command);
    }

    @Override
    public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand command) throws IOException {
        return this.applier(command).visitIndexAddRelationshipCommand(command);
    }

    @Override
    public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand command) throws IOException {
        return this.applier(command).visitIndexRemoveCommand(command);
    }

    @Override
    public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand command) throws IOException {
        return this.applier(command).visitIndexDeleteCommand(command);
    }

    @Override
    public boolean visitIndexCreateCommand(IndexCommand.CreateCommand command) throws IOException {
        this.indexConfigStore.setIfNecessary(IndexEntityType.byId(command.getEntityType()).entityClass(), this.defineCommand.getIndexName(command.getIndexNameId()), command.getConfig());
        return this.applier(command).visitIndexCreateCommand(command);
    }

    @Override
    public boolean visitIndexDefineCommand(IndexDefineCommand command) throws IOException {
        this.defineCommand = command;
        this.forward(command, this.applierByNodeIndex);
        this.forward(command, this.applierByRelationshipIndex);
        this.forward(command, this.applierByProvider);
        return false;
    }

    private void forward(IndexDefineCommand definitions, Map<String, TransactionApplier> appliers) throws IOException {
        for (CommandVisitor commandVisitor : appliers.values()) {
            commandVisitor.visitIndexDefineCommand(definitions);
        }
    }
}

