/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.Token;

public abstract class TokenAccess<R> {
    public static final TokenAccess<RelationshipType> RELATIONSHIP_TYPES = new TokenAccess<RelationshipType>(){

        @Override
        Iterator<Token> tokens(ReadOperations read) {
            return read.relationshipTypesGetAllTokens();
        }

        @Override
        RelationshipType token(Token token) {
            if (token instanceof RelationshipType) {
                return (RelationshipType)((Object)token);
            }
            return RelationshipType.withName(token.name());
        }

        @Override
        boolean inUse(ReadOperations read, int tokenId) {
            return TokenAccess.hasAny(read.constraintsGetForRelationshipType(tokenId)) || read.countsForRelationship(-1, tokenId, -1) > 0L;
        }
    };
    public static final TokenAccess<Label> LABELS = new TokenAccess<Label>(){

        @Override
        Iterator<Token> tokens(ReadOperations read) {
            return read.labelsGetAllTokens();
        }

        @Override
        Label token(Token token) {
            return Label.label(token.name());
        }

        @Override
        boolean inUse(ReadOperations read, int tokenId) {
            return TokenAccess.hasAny(read.indexesGetForLabel(tokenId)) || TokenAccess.hasAny(read.constraintsGetForLabel(tokenId)) || read.countsForNode(tokenId) > 0L;
        }
    };
    public static final TokenAccess<String> PROPERTY_KEYS = new TokenAccess<String>(){

        @Override
        Iterator<Token> tokens(ReadOperations read) {
            return read.propertyKeyGetAllTokens();
        }

        @Override
        String token(Token token) {
            return token.name();
        }

        @Override
        boolean inUse(ReadOperations read, int tokenId) {
            return true;
        }
    };

    public final ResourceIterator<R> inUse(Statement statement) {
        return TokenIterator.inUse(statement, this);
    }

    public final ResourceIterator<R> all(Statement statement) {
        return TokenIterator.all(statement, this);
    }

    private static boolean hasAny(Iterator<?> iter) {
        if (iter.hasNext()) {
            return true;
        }
        if (iter instanceof Resource) {
            ((Resource)((Object)iter)).close();
        }
        return false;
    }

    abstract Iterator<Token> tokens(ReadOperations var1);

    abstract R token(Token var1);

    abstract boolean inUse(ReadOperations var1, int var2);

    private static abstract class TokenIterator<T>
    extends PrefetchingResourceIterator<T> {
        final Statement statement;
        final TokenAccess<T> access;
        final Iterator<Token> tokens;

        TokenIterator(Statement statement, TokenAccess<T> access) {
            this.statement = statement;
            this.access = access;
            this.tokens = access.tokens(statement.readOperations());
        }

        @Override
        public void close() {
            this.statement.close();
        }

        static <T> ResourceIterator<T> inUse(Statement statement, TokenAccess<T> access) {
            return new TokenIterator<T>(statement, (TokenAccess)access){

                @Override
                protected T fetchNextOrNull() {
                    while (this.tokens.hasNext()) {
                        Token token = (Token)this.tokens.next();
                        if (!this.access.inUse(this.statement.readOperations(), token.id())) continue;
                        return this.access.token(token);
                    }
                    return null;
                }
            };
        }

        static <T> ResourceIterator<T> all(Statement statement, TokenAccess<T> access) {
            return new TokenIterator<T>(statement, (TokenAccess)access){

                @Override
                protected T fetchNextOrNull() {
                    return this.tokens.hasNext() ? (Object)this.access.token((Token)this.tokens.next()) : null;
                }
            };
        }
    }
}

