/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.NodePropertyCommandsExtractor;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;

public class RecoveryIndexingUpdatesValidator
implements IndexUpdatesValidator,
ValidatedIndexUpdates {
    private final NodePropertyCommandsExtractor extractor = new NodePropertyCommandsExtractor();
    private final PrimitiveLongSet allNodeIds = Primitive.longSet();
    private final PrimitiveLongVisitor<RuntimeException> nodeIdCollector = new PrimitiveLongVisitor<RuntimeException>(){

        public boolean visited(long value) {
            RecoveryIndexingUpdatesValidator.this.allNodeIds.add(value);
            return false;
        }
    };
    private final PrimitiveLongVisitor<RuntimeException> updatedNodeVisitor;

    public RecoveryIndexingUpdatesValidator(PrimitiveLongVisitor<RuntimeException> updatedNodeVisitor) {
        this.updatedNodeVisitor = updatedNodeVisitor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ValidatedIndexUpdates validate(TransactionRepresentation transaction) throws IOException {
        try (TransactionApplier txApplier = this.extractor.startTx(new TransactionToApply(transaction));){
            transaction.accept(txApplier);
            this.extractor.visitUpdatedNodeIds(this.nodeIdCollector);
            RecoveryIndexingUpdatesValidator recoveryIndexingUpdatesValidator = this;
            return recoveryIndexingUpdatesValidator;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean hasChanges() {
        return !this.allNodeIds.isEmpty();
    }

    @Override
    public void flush(Consumer<IndexDescriptor> affectedIndexes) {
        this.allNodeIds.visitKeys(this.updatedNodeVisitor);
        this.allNodeIds.clear();
    }

    @Override
    public void close() {
    }
}

