/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.scan;

import java.io.File;
import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class LabelScanStoreProvider
extends LifecycleAdapter
implements Comparable<LabelScanStoreProvider> {
    private static final String KEY = "lucene";
    private final LabelScanStore labelScanStore;
    private final int priority;

    public LabelScanStoreProvider(LabelScanStore labelScanStore, int priority) {
        this.labelScanStore = labelScanStore;
        this.priority = priority;
    }

    public static File getStoreDirectory(File storeRootDir) {
        return new File(new File(new File(storeRootDir, "schema"), "label"), KEY);
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    @Override
    public int compareTo(LabelScanStoreProvider o) {
        return this.priority - o.priority;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.labelScanStore + ", prio:" + this.priority + "]";
    }

    public static FullStoreChangeStream fullStoreLabelUpdateStream(final NeoStoresSupplier neoStoresSupplier) {
        return new FullStoreChangeStream(){

            @Override
            public Iterator<NodeLabelUpdate> iterator() {
                return new PrefetchingIterator<NodeLabelUpdate>(){
                    private final NodeStore nodeStore;
                    private final long highId;
                    private long current;
                    {
                        this.nodeStore = ((NeoStores)neoStoresSupplier.get()).getNodeStore();
                        this.highId = this.nodeStore.getHighestPossibleIdInUse();
                    }

                    @Override
                    protected NodeLabelUpdate fetchNextOrNull() {
                        while (this.current <= this.highId) {
                            long[] labels;
                            NodeRecord node;
                            if (!(node = this.nodeStore.forceGetRecord(this.current++)).inUse() || (labels = NodeLabelsField.parseLabelsField(node).get(this.nodeStore)).length <= 0) continue;
                            return NodeLabelUpdate.labelChanges(node.getId(), PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels);
                        }
                        return null;
                    }
                };
            }

            @Override
            public long numberOfNodes() {
                return ((NeoStores)neoStoresSupplier.get()).getNodeStore().getHighId();
            }
        };
    }

    public static interface FullStoreChangeStream
    extends Iterable<NodeLabelUpdate> {
        public long numberOfNodes();
    }
}

